package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.core.service.DwxxService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.*;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/7.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "BdcXtSjcl")
public class BdcXtSjclController extends BaseController {


    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    Repo repository;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    private DwxxService dwxxService;

    @RequestMapping(value = "")
    public String getBdcXtSjclPage(Model model) {
        List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlService.getBdcZdSqlxList();
        List<BdcZdDjzx> bdcZdDjzxList = bdcZdGlService.getBdcZdDjzxList();
        String userDwdm = super.getCurrentUserDwdm();
        String userId = super.getUserId();
        if (StringUtils.isNotBlank(userDwdm) && "0".equals(userId)) {
            userDwdm = userDwdm.substring(0,4);
        }
        List<Dwxx> dwxxList = dwxxService.getDwxxList(userDwdm, 9);
        if (CollectionUtils.isEmpty(dwxxList)) {
            dwxxList = new ArrayList<Dwxx>();
        }
        model.addAttribute("BdcZdSqlxList", bdcZdSqlxList);
        model.addAttribute("BdcZdDjzxList", bdcZdDjzxList);
        model.addAttribute("dwxxList", dwxxList);
        return "value/bdcXtSjcl";
    }


    @ResponseBody
    @RequestMapping("/getBdcXtSjclPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String sqlx, String djzx, String cllx, String clmc, String xh, String dwdm) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(sqlx))
            map.put("sqlx", sqlx);
        if (StringUtils.isNotBlank(djzx))
            map.put("djzx", djzx);
        if (StringUtils.isNotBlank(cllx))
            map.put("cllx", cllx);
        if (StringUtils.isNotBlank(clmc))
            map.put("clmc", clmc);
        if (StringUtils.isNotBlank(xh))
            map.put("xh", xh);
        if (StringUtils.isNotBlank(dwdm))
            map.put("dwdm", dwdm);
        //对登记事由处理
        return repository.selectPaging("getBdcXtSjclByPage", map, pageable);
    }

    @ResponseBody
    @RequestMapping(value = "saveBdcXtSjclRel")
    @BdcLog(controller = "保存收件材料配置日志",parmjson = "保存收件材料配置")
    public HashMap saveBdcQllxDjyyRel(BdcXtSjcl bdcXtSjcl) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            if (StringUtils.isBlank(bdcXtSjcl.getSjclid()))
                bdcXtSjcl.setSjclid(UUIDGenerator.generate());
            entityMapper.saveOrUpdate(bdcXtSjcl, bdcXtSjcl.getSjclid());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcXtSjcl")
    @BdcLog(controller = "删除收件材料配置日志",parmjson = "删除收件材料配置")
    public HashMap delBdcQllxDjyyRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcXtSjcl.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcXtSjcl.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过sqlx获取登记子项代码
     **/

    @ResponseBody
    @RequestMapping(value = "getBdcZdDjzxBySqlxDm")
    public List<BdcZdDjzx> getBdcZdDjzxBySqlxDm(String sqlx) {
        List<BdcZdDjzx> bdcZdDjzxList = null;
        if (StringUtils.isNotBlank(sqlx)) {
            List<BdcSqlxDjzxRel> bdcSqlxDjzxRelList = bdcRelService.getDjzxDmBySqlxDm(sqlx);
            if (CollectionUtils.isNotEmpty(bdcSqlxDjzxRelList)) {
                bdcZdDjzxList = new ArrayList<BdcZdDjzx>();
                for (BdcSqlxDjzxRel bdcSqlxDjzxRel : bdcSqlxDjzxRelList) {
                    BdcZdDjzx bdcZdDjzx1 = bdcZdGlService.getBdcZdDjzxByDjzxdm(bdcSqlxDjzxRel.getDjzxdm());
                    if (bdcZdDjzx1 != null) {
                        BdcZdDjzx bdcZdDjzx = new BdcZdDjzx();
                        bdcZdDjzx.setDm(bdcSqlxDjzxRel.getDjzxdm());
                        bdcZdDjzx.setMc(bdcZdDjzx1.getMc());
                        bdcZdDjzxList.add(bdcZdDjzx);
                    }
                }
            }
        }
        return bdcZdDjzxList;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcXtSjcl bdcXtSjcl, String valiteType) {
        String msg = "";
        if (bdcXtSjcl != null) {
            if (StringUtils.equals(valiteType, "update")) {
                String[] fields = {"sqlx", "djzx", "clmc", "cllx", "mrfs", "xh"};
                boolean hasData = bdcRelService.getDataByClass(bdcXtSjcl, fields);
                if (hasData)
                    msg = "表中已存在该数据";
            } else {
                String[] fields = {"sqlx", "djzx", "clmc", "cllx"};
                boolean hasData = bdcRelService.getDataByClass(bdcXtSjcl, fields);
                if (hasData)
                    msg = "表中已存在该数据";
            }
        }

        return msg;
    }

}
