package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.service.BdcXyGlService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.*;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2019/4/24.
 * @auto <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
 * @description 不动产信用管理配置
 */
@Controller
@RequestMapping("/bdcXyGl")
public class BdcXyGlController extends BaseController {

    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    BdcXyGlService bdcXyGlService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private Repo repository;

    @RequestMapping("")
    public String toOpinionConfig(Model model) {
        List<BdcZdZjlx> bdcZdZjlxList = bdcZdGlService.getBdcZdZjlxList();
        model.addAttribute("bdcZdZjlxList", bdcZdZjlxList);
        return "value/bdcXyGl";
    }

    @ResponseBody
    @RequestMapping("/getBdcXyGlPagesJson")
    public Object getBdcXyGlPagesJson(Pageable pageable, String qlrmc, String qlrzjh) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank(qlrmc)){
            map.put("qlrmc", qlrmc);
        }
        if (StringUtils.isNotBlank(qlrzjh)){
            map.put("qlrzjh", qlrzjh);
        }
        return repository.selectPaging("getBdcXyGlListByPage", map, pageable);
    }

    @ResponseBody
    @RequestMapping("/saveXyGlxx")
    public HashMap saveXyGl(Model model, BdcXygl bdcXygl,BdcXymx bdcXymx) {
        HashMap map = new HashMap();
        String result = "失败";
        if (bdcXygl != null && bdcXymx != null){
            bdcXyGlService.insertOrUpdateBdcXyGlxx(bdcXygl,bdcXymx);
            result = "保存成功";
        }
        map.put("result", result);
        return map;
    }

    @ResponseBody
    @RequestMapping("/delXyGlxx")
    public HashMap delXyGlxx(Model model, String ids) {
        HashMap map = new HashMap();
        String result = "删除失败！";
        if (StringUtils.isNotBlank(ids)) {
            bdcXyGlService.deleteBdcXyGlxx(ids);
            result = "删除成功！";
        }
        map.put("result", result);
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcXygl bdcXygl, String valiteType) {
        String msg = "";
        List<BdcXygl> bdcXyglList = null;
        if (bdcXygl != null) {
            HashMap hashMap = new HashMap();
            hashMap.put("qlrmc", bdcXygl.getQlrmc());
            hashMap.put("qlrzjh", bdcXygl.getQlrzjh());
            bdcXyglList = bdcXyGlService.getBdcXyglListByMap(hashMap);
            if (StringUtils.equals(valiteType, "update")) {
                if (CollectionUtils.isNotEmpty(bdcXyglList) && !StringUtils.equals(bdcXygl.getXyglid(), bdcXyglList.get(0).getXyglid())) {
                    msg = "表中存在相应的数据";
                }
            } else if (CollectionUtils.isNotEmpty(bdcXyglList)) {
                msg = "表中存在相应的数据";
            }

        }
        return msg;
    }

    /**
     * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
     * @param multipartFile
     * @description  导入的信用管理excel
     */
    @ResponseBody
    @RequestMapping("readExcel")
    public String readExcel(MultipartFile multipartFile) throws IOException {
        String statue = "fail";
        Map<String, String> resultMap = Maps.newHashMap();
        Map<String, String> msgMap = Maps.newHashMap();

        //获取上传的文件的文件名
        String originalFilename = multipartFile.getOriginalFilename();
        InputStream inputStream = null;
        try {
            inputStream = multipartFile.getInputStream();
        } catch (IOException e) {
            throw new AppException("获取文件输入流出错!");
        }
        if (inputStream != null) {
            String suffix = StringUtils.substring(originalFilename, originalFilename.lastIndexOf("."));
            if (StringUtils.equals(suffix, ".xls") || StringUtils.equals(suffix, ".xlsx")) {
                try {
                    msgMap = bdcXyGlService.getExcelAsInputStream(inputStream);
                    statue = "success";
                } catch (Exception e) {
                    statue = "fail";
                    e.printStackTrace();
                } finally {
                    inputStream.close();
                }
            }
        }
        resultMap.put("statue", statue);
        resultMap.putAll(msgMap);
        return JSON.toJSONString(resultMap);
    }
}
