package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcZdDjsy;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcZdDjsy")
public class BdcZdDjsyController extends BaseController {


    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;

    @RequestMapping(value = "")
    public String displayBdcQllxDjsyRelPage(Model model) {
        List<HashMap> bdcZdDjsyList = bdcZdGlService.getBdcZdDjsyList();
        model.addAttribute("BdcZdDjsyList", bdcZdDjsyList);
        return "value/bdcZdDjsy";
    }


    @ResponseBody
    @RequestMapping("/getBdcZdDjsyPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String dm, String mc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(dm))
            map.put("dm", dm);
        if (StringUtils.isNotBlank(mc))
            map.put("mc", "%" + URLDecoder.decode(mc) + "%");
        //对登记事由处理
        return repository.selectPaging("getBdcZdDjsyByPage", map, pageable);
    }


    @ResponseBody
    @RequestMapping(value = "saveBdcZdDjsy")
    @BdcLog(controller = "保存登记是由字典项配置日志",parmjson = "保存登记是由字典项配置")
    public HashMap saveBdcQllxDjsyRel(BdcZdDjsy bdcZdDjsy) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            entityMapper.saveOrUpdate(bdcZdDjsy, bdcZdDjsy.getDm());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcZdDjsy")
    @BdcLog(controller = "删除登记是由字典项配置日志",parmjson = "删除登记是由字典项配置")
    public HashMap delBdcQllxDjsyRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcZdDjsy.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcZdDjsy.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcZdDjsy bdcZdDjsy, String valiteType) {
        String msg = "";
        List<BdcZdDjsy> djsyList = null;
        if (bdcZdDjsy != null) {
            if (!StringUtils.equals(valiteType, "update")) {
                if (StringUtils.isNotBlank(bdcZdDjsy.getDm())) {
                    bdcZdDjsy = entityMapper.selectByPrimaryKey(BdcZdDjsy.class, bdcZdDjsy.getDm());
                    if (bdcZdDjsy != null)
                        msg = "表中已存在该数据";
                } else
                    msg = "新增必需要有代码";
            }
        }
        return msg;
    }
}
