package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcZdDjzx;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcZdDjzx")
public class BdcZdDjzxController extends BaseController {


    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;

    @RequestMapping(value = "")
    public String displayBdcQllxDjsyRelPage(Model model) {
        List<BdcZdDjzx> bdcZdDjzxList = bdcZdGlService.getBdcZdDjzxList();
        model.addAttribute("BdcZdDjzxList", bdcZdDjzxList);
        return "value/bdcZdDjzx";
    }


    @ResponseBody
    @RequestMapping("/getBdcZdDjzxPagesJson")
    public Object getBankFieldPagesJson(Pageable pageable, String dm, String mc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(dm))
            map.put("dm", dm);
        if (StringUtils.isNotBlank(mc))
            map.put("mc", "%" + URLDecoder.decode(mc) + "%");
        //对登记事由处理
        return repository.selectPaging("getBdcZdDjzxByPage", map, pageable);
    }


    @ResponseBody
    @RequestMapping(value = "saveBdcZdDjzx")
    @BdcLog(controller = "保存登记子项字典项配置日志",parmjson = "保存登记子项字典项配置")
    public HashMap saveBdcQllxDjsyRel(BdcZdDjzx bdcZdDjzx) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            entityMapper.saveOrUpdate(bdcZdDjzx, bdcZdDjzx.getDm());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcZdDjzx")
    @BdcLog(controller = "删除登记子项字典项配置日志",parmjson = "删除登记子项字典项配置")
    public HashMap delBdcQllxDjsyRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcZdDjzx.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcZdDjzx.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcZdDjzx bdcZdDjzx, String valiteType) {
        String msg = "";
        if (bdcZdDjzx != null) {
            List<BdcZdDjzx> bdcZdDjzxList = null;
            if (StringUtils.isNotBlank(bdcZdDjzx.getDm())) {
                Example example = new Example(BdcZdDjzx.class);
                Example.Criteria criteria = example.createCriteria();
                criteria.andEqualTo("dm", bdcZdDjzx.getDm());
                if (StringUtils.equals(valiteType, "update")) {
                    //更新验证所以的数据
                    if (StringUtils.isNotBlank(bdcZdDjzx.getMc()))
                        criteria.andEqualTo("mc", bdcZdDjzx.getMc());
                    else
                        criteria.andIsNull("mc");
                    bdcZdDjzxList = entityMapper.selectByExample(example);
                    if (CollectionUtils.isNotEmpty(bdcZdDjzxList)) {
                        msg = "表中已存在该数据";
                    }
                } else {
                    bdcZdDjzxList = entityMapper.selectByExample(example);
                    if (CollectionUtils.isNotEmpty(bdcZdDjzxList)) {
                        msg = "表中已存在该数据";
                    }
                }
            } else
                msg = "登记子项代码不能为空";

        }

        return msg;
    }
}
