package cn.gtmap.estateplat.config.web.value;/*
 * @author <a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
 * @version 1.0, 2017/11/20
 * @description 
 */

import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcZdFy;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;

@Controller
@RequestMapping(value = "/bdcZdFy", method = RequestMethod.GET)
public class BdcZdFyController extends BaseController {
    @Autowired
    Repo repository;
    @Autowired
    EntityMapper entityMapper;

    @RequestMapping(value = "")
    public String displayBdcZdFyPage(Model model) {
        return "value/bdcZdFy";
    }

    @ResponseBody
    @RequestMapping("/getBdcZdFyPagesJson")
    public Object getBdcZdSqlxRelPagesJson(Pageable pageable, String mc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(mc))
            map.put("mc", mc.trim());
        //对登记事由处理
        return repository.selectPaging("getBdcZdFyByPage", map, pageable);
    }

    @ResponseBody
    @RequestMapping(value = "delBdcZdFy")
    public HashMap delBdcZdFy(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcZdFy.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcZdFy.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite", method = RequestMethod.GET)
    public String valite(BdcZdFy bdcZdFy, String valiteType) {
        String msg = "";
        BdcZdFy bdcFy = null;
        if (bdcZdFy != null) {
            if (StringUtils.isNotBlank(bdcZdFy.getDm())) {
                bdcFy = entityMapper.selectByPrimaryKey(BdcZdFy.class, bdcZdFy.getDm());
                if (StringUtils.equals(valiteType, "update")) {
                } else {
                    if (bdcFy != null) {
                        msg = "表中已存在该数据";
                    }
                }
            } else
                msg = "法院代码不能为空";
        }

        return msg;
    }

    @ResponseBody
    @RequestMapping(value = "saveBdcZdFy", method = RequestMethod.POST)
    public HashMap saveBdcZdFy(BdcZdFy bdcZdFy) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            entityMapper.saveOrUpdate(bdcZdFy, bdcZdFy.getDm());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }
}
