package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcZdSqlx;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Controller
@RequestMapping(value = "bdcZdSqlx")
public class BdcZdSqlxController extends BaseController {


    @Autowired
    Repo repository;
    @Autowired
    BdcRelService bdcRelService;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;

    @RequestMapping(value = "")
    public String displayBdcZdSqlxRelPage(Model model) {
        List<PfWorkFlowDefineVo> workFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();
        model.addAttribute("workFlowDefineVoList", workFlowDefineVoList);
        return "value/bdcZdSqlx";
    }


    @ResponseBody
    @RequestMapping("/getBdcZdSqlxRelPagesJson")
    public Object getBdcZdSqlxRelPagesJson(Pageable pageable, String dm, String mc, String wdid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(dm))
            map.put("dm", dm);
        if (StringUtils.isNotBlank(mc))
            map.put("mc", mc.trim());
        if (StringUtils.isNotBlank(wdid))
            map.put("wdid", wdid);
        //对登记事由处理
        return repository.selectPaging("getBdcZdSqlxRelByPage", map, pageable);
    }


    @ResponseBody
    @RequestMapping(value = "saveBdcZdSqlxRel")
    @BdcLog(controller = "保存申请类型字典项配置日志",parmjson = "保存申请类型字典项配置")
    public HashMap saveBdcZdSqlxRel(BdcZdSqlx bdcZdSqlx) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            entityMapper.saveOrUpdate(bdcZdSqlx, bdcZdSqlx.getDm());
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }


    @ResponseBody
    @RequestMapping(value = "delBdcZdSqlxRel")
    @BdcLog(controller = "删除申请类型字典项配置日志",parmjson = "删除申请类型字典项配置")
    public HashMap delBdcZdSqlxRel(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        entityMapper.deleteByPrimaryKey(BdcZdSqlx.class, id);
                } else
                    entityMapper.deleteByPrimaryKey(BdcZdSqlx.class, ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(BdcZdSqlx bdcZdSqlx, String valiteType) {
        String msg = "";
        BdcZdSqlx sqlx = null;
        if (bdcZdSqlx != null) {
            if (StringUtils.isNotBlank(bdcZdSqlx.getDm())) {
                sqlx = entityMapper.selectByPrimaryKey(BdcZdSqlx.class, bdcZdSqlx.getDm());
                if (StringUtils.equals(valiteType, "update")) {
//                    //插入判断是否是代码不同，而流程一样
//                    String sqlxdm = bdcZdGlService.getSqlxDmByWdid(bdcZdSqlx.getWdid());
//                    if(StringUtils.isNotBlank(sqlxdm))
//                        msg = "表中已有该流程WDID配置";
                } else {
                    if (sqlx != null) {
                        msg = "表中已存在该数据";
                    }
//                    else {
//                        //插入判断是否是代码不同，而流程一样
//                        String sqlxdm = bdcZdGlService.getSqlxDmByWdid(bdcZdSqlx.getWdid());
//                        if(StringUtils.isNotBlank(sqlxdm))
//                            msg = "表中已有该流程WDID配置";
//                    }
                }
            } else
                msg = "申请类型代码不能为空";
        }

        return msg;
    }

    @ResponseBody
    @RequestMapping(value = "getWorkFlowName")
    public String getWorkFlowName(String wdid) {
        String workFlowName = "";
        if (StringUtils.isNotBlank(wdid)) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
            if (pfWorkFlowDefineVo != null)
                workFlowName = pfWorkFlowDefineVo.getWorkflowName();
        }
        return workFlowName;
    }
}
