/**
 *
 */
package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.service.BdcCompanyService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcXtQy;
import cn.gtmap.estateplat.model.server.core.BdcZdZjlx;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wangtao
 * @version 2016年4月20日
 * @description 对企业配置信息进行增删改查
 */
@Controller
@RequestMapping("/bdcXtCompany")
public class CompanyConfigController extends BaseController {

    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private Repo repository;

    @Autowired
    private BdcCompanyService bdcCompanyService;

    @Autowired
    BdcZdGlService bdcZdGlService;

    /**
     *
     * @author wangtao
     * @description 查询证件类型为模板提供下拉框选项
     * @param
     * @return String
     */
    @RequestMapping("")
    public String toCompanyConfig(Model model) {
        List<BdcZdZjlx> bdcZdZjlxList = bdcZdGlService.getBdcZdZjlxList();
        List<HashMap> bdcZdQlrxzList = bdcZdGlService.getQlrxzList();
        model.addAttribute("bdcZdZjlxListJson", JSONObject.toJSONString(bdcZdZjlxList));
        model.addAttribute("bdcZdZjlxList", bdcZdZjlxList);
        model.addAttribute("bdcZdQlrxzListJson", JSONObject.toJSONString(bdcZdQlrxzList));
        model.addAttribute("bdcZdQlrxzList", bdcZdQlrxzList);
        return "value/company";
    }


    /**
     *
     * @author wangtao
     * @description 查询企业信息分页数据
     * @param
     * @return Object
     */

    @ResponseBody
    @RequestMapping("/getCompanyPagesJson")
    public Object getCompanyPagesJson(Pageable pageable, String sidx, String sord, BdcXtQy bdcXtQy, String dcxc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(dcxc)) {
            map.put("dcxc", dcxc);
        }
        return repository.selectPaging("getCompanyListByPage", map, pageable);

    }

    /**
     *
     * @author wangtao
     * @description 保存企业信息
     * @param
     * @return HashMap
     */
    @ResponseBody
    @RequestMapping("/saveCompany")
    public HashMap saveCompany(Model model, BdcXtQy bdcXtQy) {
        HashMap map = new HashMap();
        String result = "保存成功";
        try {
            bdcCompanyService.insertOrUpdateByPrimaryKey(bdcXtQy);
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }

    /**
     *
     * @author wangtao
     * @description 删除企业信息
     * @param
     * @return HashMap
     */
    @ResponseBody
    @RequestMapping("/delCompany")
    public HashMap delCompany(Model model, String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            bdcCompanyService.deleteCompanyByPrimaryKey(ids);
        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    /**
     *@auther <a href="mailto:qijiadong@gtmap.cn">qijiadong</a>
     *@description 清空所有小微企业
     */
    @ResponseBody
    @RequestMapping("/delAllXwCompany")
    public HashMap delAllXwCompany(Pageable pageable) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            map.put("sfxwqy", "1");
            List<Map> dataPaging = repository.selectList("getCompanyListByPage", map);
            if (CollectionUtils.isNotEmpty(dataPaging)) {
                for (Map mapTemp : dataPaging) {
                    if (mapTemp != null && mapTemp.containsKey("QYID") && StringUtils.isNotBlank(mapTemp.get("QYID").toString())) {
                        entityMapper.deleteByPrimaryKey(BdcXtQy.class, mapTemp.get("QYID").toString());
                    }
                }
            }
        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @RequestMapping(value = "/scfj", method = RequestMethod.GET)
    public String scfj(Model model, String qyid) {
        String fileCenterUrl = "fcm";
        Integer project_fileId = null;
        if (super.fileCenterUrl != null && super.fileCenterUrl.length() > 4) {
            fileCenterUrl = fileCenterUrl + super.fileCenterUrl.substring(4);
        }
        if (StringUtils.isNotBlank(qyid)) {
            project_fileId = platformUtil.getProjectFileId(qyid);
        }
        model.addAttribute("fileCenterUrl", fileCenterUrl);
        model.addAttribute("nodeId", project_fileId);
        return "main/sjd";
    }

    /**
     *@auther <a href="mailto:qijiadong@gtmap.cn">qijiadong</a>
     *@description 导入excel
     */
    @ResponseBody
    @RequestMapping("readExcel")
    public String readExcel(MultipartFile multipartFile) throws IOException {
        Map resultMap = new HashMap();
        //获取上传的文件的文件名
        String originalFilename = multipartFile.getOriginalFilename();
        InputStream inputStream = null;
        try {
            inputStream = multipartFile.getInputStream();
        } catch (IOException e) {
            throw new AppException("获取文件输入流出错!");
        }
        if (inputStream != null) {
            String suffix = StringUtils.substring(originalFilename, originalFilename.lastIndexOf("."));
            if (StringUtils.equals(suffix, ".xls") || StringUtils.equals(suffix, ".xlsx")) {
                try {
                    resultMap = bdcCompanyService.getExcelAsInputStream(inputStream);
                    resultMap.put("statue", "success");
                } catch (Exception e) {
                    resultMap.put("statue", "fail");
                    e.printStackTrace();
                } finally {
                    inputStream.close();
                }
            }
        }
        return JSON.toJSONString(resultMap);
    }
}
