package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.service.BdcFyService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcZdFy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: liubin
 * Date: 17-8-30
 * Time: 下午5:20
 * To change this template use File | Settings | File Templates.
 */
@Controller
@RequestMapping("/bdcFy")
public class FyConfigController extends BaseController {

    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    BdcFyService bdcFyService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private Repo repository;

    @RequestMapping("")
    public String toOpinionConfig(Model model) {
        List<HashMap> fyMapList = bdcFyService.getBdcFyMapList();
        model.addAttribute("fyMapList", fyMapList);
        return "value/fy";
    }

    @ResponseBody
    @RequestMapping("/getFyPagesJson")
    public Object getFyFieldPagesJson(Pageable pageable, String fymc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(fymc))
            map.put("fymc", fymc);
        return repository.selectPaging("getFyListByPage", map, pageable);
    }

    @ResponseBody
    @RequestMapping("/saveFy")
    public HashMap saveFy(Model model, String fymc, String fydm) {
        HashMap map = new HashMap();
        String result = "保存成功";
        BdcZdFy bdcZdFy = new BdcZdFy();
        bdcZdFy.setMc(fymc);
        bdcZdFy.setDm(fydm);
        try {
            bdcFyService.insertOrUpdateByPrimaryKey(bdcZdFy);
        } catch (Exception e) {
            e.printStackTrace();
            result = "保存失败";
        }
        map.put("result", result);
        return map;
    }

    @ResponseBody
    @RequestMapping("/delFy")
    public HashMap delFy(Model model, String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            bdcFyService.deleteFyByPrimaryKey(ids);
        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping(value = "valite")
    public String valite(String fydm, String fymc, String valiteType) {
        String msg = "";
        List<BdcZdFy> bdcZdFyList = null;
        HashMap<String, String> hashMap = new HashMap();
        hashMap.put("dm", fydm);
        hashMap.put("mc", fymc);
        bdcZdFyList = bdcFyService.getBdcFyListByMap(hashMap);
        if (StringUtils.equals(valiteType, "update")) {
            if (CollectionUtils.isNotEmpty(bdcZdFyList)) {
                for (BdcZdFy bdczdFy : bdcZdFyList) {
                    if (StringUtils.equals(fymc, bdczdFy.getMc())) {
                        msg = "表中存在相应的数据";
                    }
                }
            }
        } else if (CollectionUtils.isNotEmpty(bdcZdFyList)) {
            msg = "表中存在相应的数据";
        }
        return msg;
    }
}
