package cn.gtmap.estateplat.config.web.value;

import cn.gtmap.estateplat.config.core.log.BdcLog;
import cn.gtmap.estateplat.config.core.service.BdcXtYhService;
import cn.gtmap.estateplat.config.core.service.BdcZsService;
import cn.gtmap.estateplat.config.core.service.BdcZsbhService;
import cn.gtmap.estateplat.config.core.service.DwxxService;
import cn.gtmap.estateplat.config.utils.Common;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.PlatformUtil;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repository;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.model.server.core.BdcZsbh;
import cn.gtmap.estateplat.model.server.core.Dwxx;
import com.gtis.config.AppConfig;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfUserVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: sunchao
 * Date: 15-9-18
 * Time: 上午11:19
 * To change this template use File | Settings | File Templates.
 */
@Controller
@RequestMapping("/zsBhGl")
public class ZsBhGlConntroller extends BaseController {
    @Autowired
    Repository repository;
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    private DwxxService dwxxService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcZsbhService bdcZsbhService;
    @Autowired
    private BdcXtYhService bdcXtYhService;

    @RequestMapping(value = "")
    public String zsBhGlNew(Model model, String xgdyzt) {
        //加载部门list
        List<PfOrganVo> organVoList = PlatformUtil.getOrganList();
        model.addAttribute("organVoList", organVoList);
        //根据行政区过滤
        String userDwdm = super.getWhereXzqdm();
        List<Dwxx> dwxxList = dwxxService.getDwxxList(userDwdm, 9);

        if (dwxxList == null) {
            dwxxList = new ArrayList<Dwxx>();
        }
        if (StringUtils.isNotBlank(xgdyzt)) {
            model.addAttribute("xgdyzt", xgdyzt);
        }
        model.addAttribute("dwxxList", dwxxList);
        String addZsbhJzdw = AppConfig.getProperty("addZsbhJzdw");
        model.addAttribute("addZsbhJzdw", addZsbhJzdw);
        model.addAttribute("bdcXtYhList", bdcXtYhService.getBdcXtYhMapList());
        return "value/zsBhGl";
    }

    @ResponseBody
    @RequestMapping("/getBdcZsBhListByPage")
    public Object getBdcZsBhListByPage(Pageable pageable, String hhSearch, String qsbh, String jsbh, String jsrq, String qsrq, String dwdm, BdcZsbh bdcZsbh, String organId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(hhSearch)) {
            if (hhSearch.contains("证书"))
                map.put("hhSearch", "zs");
            else if (hhSearch.contains("证明书"))
                map.put("hhSearch", "zms");
            else
                map.put("hhSearch", StringUtils.deleteWhitespace(hhSearch));
        } else {
            if (StringUtils.isNotBlank(jsrq)) {
                map.put("jsrq", jsrq);
            }
            if (StringUtils.isNotBlank(qsrq)) {
                map.put("qsrq", qsrq);
            }

            map.put("qsbh", qsbh);
            if (StringUtils.isNotBlank(dwdm)) {
                while (dwdm.endsWith("0")) {
                    dwdm = dwdm.substring(0, dwdm.length() - 1);
                }
            }
            map.put("dwdm", dwdm);
            map.put("jsbh", jsbh);

            String dzzmPrefix = AppConfig.getProperty("zsbhgl.dzzmh.rule.prefix");
            String dzzmSxh = AppConfig.getProperty("zsbhgl.dzzmh.rule.sxh");
            if (StringUtils.isNotBlank(dzzmPrefix) && StringUtils.isNotBlank(dzzmSxh)) {
                map.put("qsnum", dzzmPrefix.length() + 1);
                map.put("jsnum", dzzmPrefix.length() + dzzmSxh.length());
            } else {
                map.put("qsnum", 3);
                map.put("jsnum", 9);
            }

            if (bdcZsbh != null) {
                map.put("cjr", bdcZsbh.getCjr());
                map.put("lqr", bdcZsbh.getLqr());
                map.put("zslx", bdcZsbh.getZslx());
                if (StringUtils.isNotBlank(bdcZsbh.getSyqk())) {
                    map.put("syqk", bdcZsbh.getSyqk().split(","));
                }
            }
        }
        //根据行政区过滤
        String userDwdm = super.getWhereXzqdm();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(userDwdm))
            map.put("xzqdm", userDwdm);

        //根据页面选择的部门id，查询平台库中该部门下的所有用户
        List<PfUserVo> userList = PlatformUtil.getUsersByOrganId(organId);
        StringBuffer userNameStr = new StringBuffer();
        if (CollectionUtils.isNotEmpty(userList)) {
            for (int i = 0; i < userList.size(); i++) {
                PfUserVo userVo = userList.get(i);
                userNameStr.append(userVo.getUserName()).append(",");
            }
            if (StringUtils.isNotBlank(userNameStr) && userNameStr.length() > 0) {
                String tmpUserNameStr = userNameStr.toString().substring(0, userNameStr.length() - 1);
                String[] userNameArr = tmpUserNameStr.split(",");
                map.put("cjrList", userNameArr);
            }
        }
        Page<HashMap> dataPaging = repository.selectPaging("getBdcZsBhListByPage", map, pageable);
        return dataPaging;
    }

    @ResponseBody
    @RequestMapping("/getBdcZsBhZfListByPage")
    public Object getBdcZsBhZfListByPage(Pageable pageable, String hhSearch) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(hhSearch)) {
            map.put("hhSearch", StringUtils.deleteWhitespace(hhSearch));
        }
        //根据行政区过滤
        String userDwdm = super.getWhereXzqdm();
        if (org.apache.commons.lang3.StringUtils.isNotBlank(userDwdm))
            map.put("xzqdm", userDwdm);
        //作废状态证书编号
        map.put("syqk", new String[]{Constants.BDCZSBH_SYQK_ZF});

        Page<HashMap> dataPaging = repository.selectPaging("getBdcZsBhListByPage", map, pageable);
        return dataPaging;
    }

    @ResponseBody
    @RequestMapping("/getBdcZsBhLqqjListByPage")
    public Object getBdcZsBhLqqjListByPage(Pageable pageable, String hhSearch) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(hhSearch)) {
            map.put("hhSearch", StringUtils.deleteWhitespace(hhSearch));
        }

        Page<HashMap> dataPaging = repository.selectPaging("getBdcZsBhLqqjListByPage", map, pageable);
        return dataPaging;
    }

    @ResponseBody
    @RequestMapping("/saveZsBh")
    @BdcLog(controller = "保存证书编号配置日志",parmjson = "保存证书编号配置")
    public String saveZsBh(Model model, String zslx, String qsbh, String jsbh, String dwdm, String sccs, String xh, String jzdw
    ,String syyhmc) {
        if (StringUtils.isBlank(dwdm)) {
            dwdm = super.getWhereXzqdm();
        } else {
            while (dwdm.endsWith("0")) {
                dwdm = dwdm.substring(0, dwdm.length() - 1);
            }
        }
        HashMap map = new HashMap();
        map.put("qsbh", qsbh);
        map.put("jsbh", jsbh);
        map.put("zslx", zslx);
        map.put("jzdw", jzdw);
        String dzzmPrefix = AppConfig.getProperty("zsbhgl.dzzmh.rule.prefix");
        String dzzmSxh = AppConfig.getProperty("zsbhgl.dzzmh.rule.sxh");
        if (StringUtils.isNotBlank(dzzmPrefix) && StringUtils.isNotBlank(dzzmSxh)) {
            map.put("qsnum", dzzmPrefix.length() + 1);
            map.put("jsnum", dzzmPrefix.length() + dzzmSxh.length());
        } else {
            map.put("qsnum", 3);
            map.put("jsnum", 9);
        }
        List<BdcZsbh> bdcZsbhList = bdcZsbhService.getBdcZsBhListByBhfw(map);
        BdcZsbh bdcZsbh = new BdcZsbh();
        bdcZsbh.setCjr(super.getUserName());
        bdcZsbh.setCjrid(super.getUserId());
        bdcZsbh.setDwdm(dwdm);
        bdcZsbh.setZslx(zslx);
        bdcZsbh.setCjsj(new Date());
        bdcZsbh.setSccs(sccs);
        Calendar a = Calendar.getInstance();
        bdcZsbh.setNf(a.get(Calendar.YEAR) + "");
        bdcZsbh.setXh(xh);
        bdcZsbh.setXhksbh(qsbh);
        bdcZsbh.setXhjsbh(jsbh);
        bdcZsbh.setSyqk(Constants.BDCZSBH_SYQK_WLY);//未领用
        bdcZsbh.setJzdw(jzdw);
        bdcZsbh.setSyyhmc(syyhmc);
        String result = bdcZsbhService.checkAndSaveZsh(bdcZsbhList, bdcZsbh, qsbh, jsbh);
        return result;
    }

    @ResponseBody
    @RequestMapping("/lqZsBh")
    public String lqZsBh(Model model, String zslx, String qsxh, String jsxh, String dwdm, String lqdw, String lqrid, String bz) {
        String result = "失败";
        //验证是否存在对应箱号
        String sqdm = "";

        if (StringUtils.isNotBlank(dwdm) && StringUtils.length(dwdm) > 1)
            sqdm = StringUtils.substring(dwdm, 0, 2);


        HashMap map = new HashMap();
        map.put("qsbh", Common.getBh(sqdm, qsxh, 9));
        map.put("jsbh", Common.getBh(sqdm, jsxh, 9));
        map.put("zslx", zslx);
        List<BdcZsbh> bdcZsbhList = bdcZsbhService.getBdcZsBhListByQzBh(map);
        map.put("nosyqk", "0");//查看是否存在已领取
        List<BdcZsbh> bdcZsbhList1 = bdcZsbhService.getBdcZsBhListByQzBh(map);
        if (CollectionUtils.isNotEmpty(bdcZsbhList1)) {
            return "选择的证书编号存在已被领用";
        } else if (CollectionUtils.isNotEmpty(bdcZsbhList)) {
            for (BdcZsbh bdcZsbh : bdcZsbhList) {
                bdcZsbh.setLqrid(lqrid);
                if (StringUtils.isNotBlank(lqrid)) {
                    bdcZsbh.setLqr(getUserNameById(lqrid));
                }
                bdcZsbh.setLqsj(new Date());
                bdcZsbh.setLqdw(lqdw);
                bdcZsbh.setBz(bz);
                bdcZsbh.setDwdm(dwdm);
                bdcZsbh.setSyqk(Constants.BDCZSBH_SYQK_YLY);
                entityMapper.saveOrUpdate(bdcZsbh, bdcZsbh.getZsbhid());
            }
            result = "success";
        } else {
            return "选择的编号区间找不到证书编号";
        }
        return result;
    }

    @ResponseBody
    @RequestMapping("/xgdyzt")
    public String xgdyzt(Model model, String zslx, String qsxh, String jsxh, String sfdy) {
        String result = "失败";
        //验证是否存在对应箱号
        HashMap map = new HashMap();
        map.put("qsbh", qsxh);
        map.put("jsbh", jsxh);
        map.put("zslx", zslx);
        List<BdcZsbh> bdcZsbhList = bdcZsbhService.getBdcZsBhListByQzBh(map);
        if (CollectionUtils.isNotEmpty(bdcZsbhList)) {
            for (BdcZsbh bdcZsbh : bdcZsbhList) {
                bdcZsbh.setSfdy(sfdy);
                entityMapper.saveOrUpdate(bdcZsbh, bdcZsbh.getZsbhid());
            }
            result = "success";
        }else{
            return "未找到对应证书编号";
        }
        return result;
    }

    @ResponseBody
    @RequestMapping("/handleZsBh")
    public String handleZsBh(Model model, String editZsbhid, @RequestParam(value = "editZsbh", required = false) String
            editZsbh, @RequestParam(value = "editBdcqzh", required = false) String editBdcqzh, @RequestParam(value = "editSyqk", required = false) String editSyqk
            , @RequestParam(value = "editXhjzr", required = false) String editXhjzr,
                             @RequestParam(value = "editQtqksm", required = false) String editQtqksm, @RequestParam(value = "editYy", required = false) String editYy
            , @RequestParam(value = "editBz", required = false) String editBz) {
        String result = "失败";
        HashMap map = new HashMap();
        map.put("zsbhid", editZsbhid);
        List<BdcZsbh> bdcZsbhList = bdcZsbhService.getBdcZsBhListByBhfw(map);
        if (CollectionUtils.isNotEmpty(bdcZsbhList)) {
            BdcZsbh bdcZsbh = bdcZsbhList.get(0);
            bdcZsbh.setSyqk(editSyqk);
            if (StringUtils.equals(editSyqk, Constants.BDCZSBH_SYQK_WLY)) {
                bdcZsbh.setBz(editBz);
                bdcZsbh.setSyqk(Constants.BDCZSBH_SYQK_WLY);
            } else if (StringUtils.equals(editSyqk, Constants.BDCZSBH_SYQK_YDZ)) {
                bdcZsbh.setBz(editBz);
                if (StringUtils.isNotBlank(editBdcqzh)) {
                    List<BdcZs> bdcZsList = bdcZsService.getBdcZsByBdcqzh(StringUtils.trim(editBdcqzh));
                    if (CollectionUtils.isNotEmpty(bdcZsList))
                        bdcZsbh.setZsid(bdcZsList.get(0).getZsid());
                    else {
                        result = "该不动产权证书不存在！";
                        return result;
                    }
                }
                bdcZsbh.setSyqk(Constants.BDCZSBH_SYQK_YDZ);
            } else if (StringUtils.equals(editSyqk, Constants.BDCZSBH_SYQK_ZF)) {
                bdcZsbh.setBz(editBz);
                bdcZsbh.setBfyy(editYy);
                bdcZsbh.setZfr(super.getUserName());
                bdcZsbh.setZfrid(super.getUserId());
                bdcZsbh.setZfsj(new Date());
                if (StringUtils.isNotBlank(editBdcqzh)) {
                    List<BdcZs> bdcZsList = bdcZsService.getBdcZsByBdcqzh(StringUtils.trim(editBdcqzh));
                    if (CollectionUtils.isNotEmpty(bdcZsList))
                        bdcZsbh.setZsid(bdcZsList.get(0).getZsid());
                    else {
                        result = "该不动产权证书不存在！";
                        return result;
                    }
                }
                bdcZsbh.setSyqk(Constants.BDCZSBH_SYQK_ZF);
            } else if (StringUtils.equals(editSyqk, Constants.BDCZSBH_SYQK_YSY)) {
                bdcZsbh.setBz(editBz);
                bdcZsbh.setSyr(super.getUserName());
                bdcZsbh.setSyrid(super.getUserId());
                bdcZsbh.setSysj(new Date());
                if (StringUtils.isNotBlank(editBdcqzh)) {
                    List<BdcZs> bdcZsList = bdcZsService.getBdcZsByBdcqzh(StringUtils.trim(editBdcqzh));
                    if (CollectionUtils.isNotEmpty(bdcZsList))
                        bdcZsbh.setZsid(bdcZsList.get(0).getZsid());
                    else {
                        result = "该不动产权证书不存在！";
                        return result;
                    }
                }
                bdcZsbh.setSyqk(Constants.BDCZSBH_SYQK_YSY);
            } else if (StringUtils.equals(editSyqk, Constants.BDCZSBH_SYQK_YS)) {
                bdcZsbh.setBz(editBz);
                bdcZsbh.setYsyy(editYy);
                bdcZsbh.setYsczr(super.getUserName());
                bdcZsbh.setYsczrid(super.getUserId());
                bdcZsbh.setYssj(new Date());
                if (StringUtils.isNotBlank(editBdcqzh)) {
                    List<BdcZs> bdcZsList = bdcZsService.getBdcZsByBdcqzh(StringUtils.trim(editBdcqzh));
                    if (CollectionUtils.isNotEmpty(bdcZsList))
                        bdcZsbh.setZsid(bdcZsList.get(0).getZsid());
                    else {
                        result = "该不动产权证书不存在！";
                        return result;
                    }
                }
                bdcZsbh.setSyqk(Constants.BDCZSBH_SYQK_YS);
            } else if (StringUtils.equals(editSyqk, Constants.BDCZSBH_SYQK_XH)) {
                bdcZsbh.setBz(editBz);
                bdcZsbh.setXhyy(editYy);
                bdcZsbh.setXhr(super.getUserName());
                bdcZsbh.setXhrid(super.getUserId());
                bdcZsbh.setXhsj(new Date());
                bdcZsbh.setXhjzr(editXhjzr);
                if (StringUtils.isNotBlank(editBdcqzh)) {
                    List<BdcZs> bdcZsList = bdcZsService.getBdcZsByBdcqzh(StringUtils.trim(editBdcqzh));
                    if (CollectionUtils.isNotEmpty(bdcZsList))
                        bdcZsbh.setZsid(bdcZsList.get(0).getZsid());
                    else {
                        result = "该不动产权证书不存在！";
                        return result;
                    }
                }
                bdcZsbh.setSyqk(Constants.BDCZSBH_SYQK_XH);
            } else if (StringUtils.equals(editSyqk, Constants.BDCZSBH_SYQK_YLY)) {
                bdcZsbh.setBz(editBz);
                bdcZsbh.setSyqk(Constants.BDCZSBH_SYQK_YLY);
            } else if (StringUtils.equals(editSyqk, Constants.BDCZSBH_SYQK_QT)) {
                bdcZsbh.setBz(editBz);
                bdcZsbh.setQtqksm(editQtqksm);
                bdcZsbh.setQtczr(super.getUserName());
                bdcZsbh.setQtczrid(super.getUserId());
                bdcZsbh.setQtczsj(new Date());
                bdcZsbh.setSyqk(Constants.BDCZSBH_SYQK_QT);
            }
            entityMapper.saveOrUpdate(bdcZsbh, bdcZsbh.getZsbhid());
            result = "操作成功";
        }
        return result;
    }

    //销毁作废的证书编号
    @ResponseBody
    @RequestMapping("/xhZsBh")
    public String xhZsBh(Model model, String zsbhid, String xhjzr, String zszt) {
        String result = "失败";
        HashMap map = new HashMap();
        if (StringUtils.isNotBlank(zsbhid)) {
            map.put("zsbhid", zsbhid);
            List<BdcZsbh> bdcZsbhList = bdcZsbhService.getBdcZsBhListByBhfw(map);
            if (CollectionUtils.isNotEmpty(bdcZsbhList)) {
                BdcZsbh bdcZsbh = bdcZsbhList.get(0);
                if (bdcZsbh.getSyqk().equals(Constants.BDCZSBH_SYQK_ZF)) {
                    bdcZsbh.setSyqk(zszt);
//                    bdcZsbh.setXhr(super.getUserName());
//                    bdcZsbh.setXhrid(super.getUserId());
//                    bdcZsbh.setXhsj(new Date());
//                    bdcZsbh.setXhjzr(xhjzr);
                    entityMapper.saveOrUpdate(bdcZsbh, bdcZsbh.getZsbhid());

                    result = "操作成功";
                } else {
                    result = "请选择作废的证书编号进行销毁";
                }
            }
        }
        return result;
    }

    @ResponseBody
    @RequestMapping("/getZsbH")
    public String getZsbH(Model model, String zslx, String zsid, String dwdm) {
        String result = "失败";
        String zsbh = "";
        //证书编号分配到各乡镇所,需要通过dwdm区分
        String bdczsbhFilterZsbhXzdm = AppConfig.getProperty("bdczsbh.filterZsbh.xzdm");
        //按人员分配
        String isry = AppConfig.getProperty("getZsbhByRy");
        if (StringUtils.isNotBlank(bdczsbhFilterZsbhXzdm) && StringUtils.equals(bdczsbhFilterZsbhXzdm.trim(), "true")) {
            HashMap hashMap = new HashMap();
            hashMap.put("zslx", zslx);
            hashMap.put("dwdm", dwdm);
            //按人员分配
            if (StringUtils.equals(isry, "true"))
                hashMap.put("lqrid", super.getUserId());
            zsbh = bdcZsbhService.getZsbhByDwdm(hashMap);
        } else if (StringUtils.equals(isry, "true")) {
            HashMap hashMap = new HashMap();
            hashMap.put("zslx", zslx);
            hashMap.put("lqrid", super.getUserId());
            zsbh = bdcZsbhService.getZsbhByDwdm(hashMap);
        } else
            zsbh = bdcZsbhService.getZsbh(zslx);
        if (StringUtils.isNotBlank(zslx)) {
            List<BdcZsbh> bdcZsbhList = new ArrayList<BdcZsbh>();
            if (StringUtils.isNotBlank(zsbh)) {
                HashMap map = new HashMap();
                map.put("zsbh", zsbh);
                map.put("zslx", zslx);
                map.put("dwdm", dwdm);
                bdcZsbhList = bdcZsbhService.getBdcZsBhListByBhfw(map);
            }
            BdcZs bdcZs = bdcZsService.queryBdcZsByQlrid(zsid);
            if (CollectionUtils.isNotEmpty(bdcZsbhList) && bdcZs != null) {
                BdcZsbh bdcZsbh = bdcZsbhList.get(0);
                bdcZsbh.setSyqk("3");
                bdcZsbh.setLqr(super.getUserName());
                bdcZsbh.setLqrid(super.getUserId());
                bdcZsbh.setZsid(zsid);
                entityMapper.saveOrUpdate(bdcZsbh, bdcZsbh.getZsbhid());
                bdcZs.setBh(bdcZsbh.getZsbh());
                entityMapper.saveOrUpdate(bdcZs, bdcZs.getZsid());
                HashMap maphy = new HashMap();
                maphy.put("zsid", zsid);
                maphy.put("zslx", zslx);
                List<BdcZsbh> bdcZsbhListhy = bdcZsbhService.getBdcZsBhListByBhfw(maphy);
                if (CollectionUtils.isNotEmpty(bdcZsbhListhy)) {
                    for (BdcZsbh bdcZsbhhy : bdcZsbhListhy) {
                        if ((!StringUtils.equals(bdcZsbhhy.getZsbh(), bdcZsbh.getZsbh())) && (StringUtils.equals(bdcZsbhhy.getSyqk(), Constants.BDCZSBH_SYQK_WLY))) {
                            bdcZsbhhy.setZsid("");
                            bdcZsbhhy.setSyqk(Constants.BDCZSBH_SYQK_WLY);
                            bdcZsbhhy.setLqr("");
                            bdcZsbhhy.setLqrid("");
                            bdcZsbhhy.setBfyy("");
                            entityMapper.saveOrUpdate(bdcZsbhhy, bdcZsbhhy.getZsbhid());
                        }
                    }
                }
            }
            result = zsbh;
        }
        return result;
    }

    @ResponseBody
    @RequestMapping("/getZsbh")
    public BdcZsbh getZsbh(Model model, String zsbhid) {
        BdcZsbh bdcZsbh = null;
        HashMap map = new HashMap();
        map.put("zsbhid", zsbhid);
        List<BdcZsbh> bdcZsbhList = bdcZsbhService.getBdcZsBhListByBhfw(map);
        if (CollectionUtils.isNotEmpty(bdcZsbhList)) {
            bdcZsbh = bdcZsbhList.get(0);
            if (StringUtils.isNotBlank(bdcZsbh.getZsid())) {
                BdcZs bdcZs = entityMapper.selectByPrimaryKey(BdcZs.class, bdcZsbh.getZsid());
                if (bdcZs != null) {
                    bdcZsbh.setZsid(bdcZs.getBdcqzh());
                }
            }
        }
        if (bdcZsbh == null)
            bdcZsbh = new BdcZsbh();
        return bdcZsbh;
    }

    //批量导入证书编号
    @ResponseBody
    @RequestMapping("/getZsbhByPl")
    public String getZsbhByPl(Model model, String wiid) {
        String zslx = "";
        String result = "失败";
        List<BdcZs> bdcZsList = bdcZsService.getPlZsByWiid(wiid);
        if (CollectionUtils.isNotEmpty(bdcZsList)) {
            for (int i = 0; i < bdcZsList.size(); i++) {
                BdcZs bdcZs = bdcZsList.get(i);
                if (!StringUtils.equals(Constants.BDCQSCDJZ_BH_FONT, bdcZs.getZstype())) {
                    if (StringUtils.equals(Constants.BDCQZM_BH_FONT, bdcZs.getZstype())) {
                        zslx = Constants.BDCQZM_BH_DM;
                    } else {
                        zslx = Constants.BDCQZS_BH_DM;
                    }
                    Map wsyMap = bdcZsbhService.getZsYjByZslx(zslx);
                    if (StringUtils.isNotBlank(wsyMap.get("WSY").toString())) {
                        int wsy = Integer.parseInt(wsyMap.get("WSY").toString());
                        if (wsy < bdcZsList.size()) {
                            return "证书编号不足请添加";
                        }
                    } else {
                        return "证书编号不足请添加";
                    }

                    String zsbh = bdcZsbhService.getZsbh(zslx);
                    if (StringUtils.isNotBlank(zslx)) {
                        HashMap map = new HashMap();
                        map.put("zsbh", zsbh);
                        map.put("zslx", zslx);
                        List<BdcZsbh> bdcZsbhList = bdcZsbhService.getBdcZsBhListByBhfw(map);
                        if (CollectionUtils.isNotEmpty(bdcZsbhList)) {
                            BdcZsbh bdcZsbh = bdcZsbhList.get(0);
                            bdcZsbh.setSyqk("3");
                            bdcZsbh.setLqr(super.getUserName());
                            bdcZsbh.setLqrid(super.getUserId());
                            bdcZsbh.setZsid(bdcZs.getZsid());
                            entityMapper.saveOrUpdate(bdcZsbh, bdcZsbh.getZsbhid());
                            bdcZs.setBh(zsbh);
                            entityMapper.saveOrUpdate(bdcZs, bdcZs.getZsid());
                            HashMap maphy = new HashMap();
                            maphy.put("zsid", bdcZs.getZsid());
                            maphy.put("zslx", zslx);
                            List<BdcZsbh> bdcZsbhListhy = bdcZsbhService.getBdcZsBhListByBhfw(maphy);
                            if (CollectionUtils.isNotEmpty(bdcZsbhListhy)) {
                                for (BdcZsbh bdcZsbhhy : bdcZsbhListhy) {
                                    if ((!StringUtils.equals(bdcZsbhhy.getZsbh(), bdcZsbh.getZsbh())) && (StringUtils.equals(bdcZsbhhy.getSyqk(), Constants.BDCZSBH_SYQK_WLY))) {
                                        bdcZsbhhy.setZsid("");
                                        bdcZsbhhy.setSyqk(Constants.BDCZSBH_SYQK_WLY);
                                        bdcZsbhhy.setLqr("");
                                        bdcZsbhhy.setLqrid("");
                                        bdcZsbhhy.setBfyy("");
                                        entityMapper.saveOrUpdate(bdcZsbhhy, bdcZsbhhy.getZsbhid());
                                    }
                                }
                            }
                        }
                    }
                }
            }
            result = "批量添加证书编号成功";
        }
        return result;
    }

    @RequestMapping(value = "/zsxhTz")
    public String zsxhTz(Model model) {
        return "/value/zsxhTz";
    }

    @RequestMapping(value = "/zslqqjtz")
    public String zslqqjtz(Model model) {
        return "/value/zslqqjtz";
    }

    //销毁台账
    @RequestMapping(value = "/bdczsbhXhList")
    public String bdczsbhXhList(Model model) {
        return "/query/bdczsbhXhList";
    }

    //销毁台账
    @RequestMapping(value = "/bdczsbhLyList")
    public String bdczsbhLyList(Model model) {
        return "/query/bdczsbhLyList";
    }

    //销毁编号查询
    @ResponseBody
    @RequestMapping("/getBdcZsBhXhListByPage")
    public Object getBdcZsBhXhListByPage(Pageable pageable, String hhSearch) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(hhSearch)) {
            map.put("hhSearch", StringUtils.deleteWhitespace(hhSearch));
        }
        Page<HashMap> dataPaging = repository.selectPaging("getBdcZsBhXhListByPage", map, pageable);
        return dataPaging;
    }

    //领用查询
    @ResponseBody
    @RequestMapping("/getBdcZsBhLqListByPage")
    public Object getBdcZsBhLqListByPage(Pageable pageable, String hhSearch) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(hhSearch)) {
            map.put("hhSearch", StringUtils.deleteWhitespace(hhSearch));
        }

        Page<HashMap> dataPaging = repository.selectPaging("getBdcZsBhLqListByPage", map, pageable);
        return dataPaging;
    }

    //根据领取部门获取领取人列表
    @ResponseBody
    @RequestMapping(value = "getLqrByLqdw")
    public Object getLqrByLqdw(Model model, String lqdw) {
        List<PfUserVo> pfUserVoList = getUserListByOrgan(lqdw);
        return pfUserVoList;
    }

    //填报验证
    @ResponseBody
    @RequestMapping(value = "/checkZsBh", method = RequestMethod.GET)
    public String checkZsBh(@RequestParam(value = "proid", required = false) String proid, @RequestParam(value = "zsid", required = false) String zsid, @RequestParam(value = "zsbh", required = false) String zsbh
            , @RequestParam(value = "zslx", required = false) String zslx) {

        List<PfOrganVo> pfOrganVoList = super.getOrganName();
        String organName = pfOrganVoList.get(0).getOrganName();
        String syr = super.getUserName();
        if (StringUtils.isNotBlank(proid)) {
            String xx = bdcZsbhService.checkZsbhNew(proid, zslx, zsbh, organName, zsid, syr);
            if (StringUtils.equals(xx, "success") && StringUtils.isNotBlank(zsid)) {
                BdcZs bdcZs = entityMapper.selectByPrimaryKey(BdcZs.class, zsid);
                if (bdcZs != null) {
                    bdcZs.setBh(zsbh);
                    entityMapper.saveOrUpdate(bdcZs, bdcZs.getZsid());
                }
            }
            if (StringUtils.isBlank(xx)) {
                return "success";
            } else {
                return xx;
            }
        } else {
            return "error";
        }

    }
}
