package cn.gtmap.estateplat.config.web.zj;


import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.core.service.BdcZjjlService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.PlatformUtil;
import cn.gtmap.estateplat.config.utils.WorkFlowXml;
import cn.gtmap.estateplat.config.utils.WorkFlowXmlUtil;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcZjjl;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysSignService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.*;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
 * @Time 2020/4/15 14:13
 * @description 不动产质检
 */
@Controller
@RequestMapping("/bdczj")
public class BdczjController extends BaseController {
    @Autowired
    private SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    private Repo repository;
    @Autowired
    private BdcZjjlService bdcZjjlService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private SysSignService signService;

    @RequestMapping("")
    public String index(Model model) {
        List<PfBusinessVo> businessList = new ArrayList<PfBusinessVo>();
        List<PfBusinessVo> businessTemp = sysWorkFlowDefineService.getBusinessList();
        if (CollectionUtils.isNotEmpty(businessTemp)) {
            for (PfBusinessVo pfBusinessVo : businessTemp) {
                if (!CommonUtil.indexOfStrs(Constants.SQLXMC_NOTSHOW, pfBusinessVo.getBusinessName())) {
                    businessList.add(pfBusinessVo);
                }
            }
        }
        model.addAttribute("businessList", businessList);
        return "query/zj/bdczj";
    }

    /**
     * @param businessId    :登记类型id
     * @param wfDefintionId :流程类型id
     * @param activityName  :节点名称
     * @param cqjs          :抽取件数
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     * @Time 2020/4/16 9:49
     * @description 查询质检信息
     */
    @RequestMapping("/queryZjxx")
    @ResponseBody
    public Object queryZjxx(Pageable pageable, @RequestParam(value = "businessId", required = false) String businessId,
                            @RequestParam(value = "wfDefintionId", required = false) String wfDefintionId,
                            @RequestParam(value = "activityName", required = false) String activityName,
                            @RequestParam(value = "cqjs", required = false) String cqjs, @RequestParam(value = "cqbl", required = false) String cqbl) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("businessId", businessId);
        paramMap.put("wfDefintionId", wfDefintionId);
        paramMap.put("activityName", activityName);
        paramMap.put("cqjs", cqjs);
        Page<HashMap> dataPaging = repository.selectPaging("queryZjxxListByPage", paramMap, pageable);
        if (StringUtils.equals(cqbl, "1.0")) {
            return dataPaging;
        } else {
            int records = dataPaging.getRecords();
            BigDecimal cqblDecimal = new BigDecimal(cqbl);
            BigDecimal recordsDecimal = new BigDecimal(records);
            BigDecimal resultDecimal = cqblDecimal.multiply(recordsDecimal);
            cqjs = String.valueOf(Math.ceil(resultDecimal.doubleValue()));
            paramMap.put("cqjs", cqjs);
            return repository.selectPaging("queryZjxxListByPage", paramMap, pageable);
        }
    }

    @RequestMapping("/saveZjjl")
    @ResponseBody
    private Object initZjjl(@RequestParam(value = "wiid", required = false) String wiid,
                            @RequestParam(value = "zjr", required = false) String zjr,
                            @RequestParam(value = "zjyy", required = false) String zjyy,
                            @RequestParam(value = "zjzt", required = false) String zjzt) {
        HashMap map = Maps.newHashMap();
        String msg = bdcZjjlService.saveBdczjjl(wiid, zjr, zjyy, zjzt);
        map.put("msg", msg);
        return map;
    }

    @RequestMapping("/zjjlxx")
    public String zjjlxx(Model model) {
        List<PfUserVo> pfUserVoList = bdcZjjlService.getPfuserByRoleName(AppConfig.getProperty("zjjsmc"));
        model.addAttribute("pfUserVoList", pfUserVoList);
        return "query/zj/bdczjjlTabList";
    }

    @RequestMapping("/queryZjjlxx")
    @ResponseBody
    public Object queryZjjlxx(Pageable pageable, @RequestParam(value = "zjksrq", required = false) String zjksrq,
                              @RequestParam(value = "zjjsrq", required = false) String zjjsrq,
                              @RequestParam(value = "zjr", required = false) String zjr,
                              @RequestParam(value = "tsr", required = false) String tsr,
                              @RequestParam(value = "zjzt", required = false) String zjzt,
                              @RequestParam(value = "zjbhg", required = false) String zjbhg) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("zjksrq", zjksrq);
        paramMap.put("zjjsrq", zjjsrq);
        paramMap.put("zjr", zjr);
        paramMap.put("tsr", tsr);
        paramMap.put("zjzt", zjzt);
        paramMap.put("zjbhg", zjbhg);
        return repository.selectPaging("queryZjjlxxListByPage", paramMap, pageable);
    }

    @RequestMapping("/queryZjtjxx")
    @ResponseBody
    public Object queryZjtjxx(Pageable pageable, @RequestParam(value = "zjksrq", required = false) String zjksrq,
                              @RequestParam(value = "zjjsrq", required = false) String zjjsrq,
                              @RequestParam(value = "zjr", required = false) String zjr,
                              @RequestParam(value = "zjbhg", required = false) String zjbhg) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("zjksrq", zjksrq);
        paramMap.put("zjjsrq", zjjsrq);
        paramMap.put("zjr", zjr);
        paramMap.put("zjbhg", zjbhg);
        return repository.selectPaging("queryZjtjxxListByPage", paramMap, pageable);
    }

    @RequestMapping("/exportZjjlxx")
    @ResponseBody
    public void exportZjjlxx(Pageable pageable, HttpServletRequest request, HttpServletResponse response,
                             @RequestParam(value = "zjksrq", required = false) String zjksrq,
                             @RequestParam(value = "zjjsrq", required = false) String zjjsrq,
                             @RequestParam(value = "zjr", required = false) String zjr,
                             @RequestParam(value = "zjbhg", required = false) String zjbhg) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("zjksrq", zjksrq);
        paramMap.put("zjjsrq", zjjsrq);
        paramMap.put("zjr", zjr);
        paramMap.put("zjbhg", zjbhg);
        Page<Map> queryZjtjxxList = repository.selectPaging("queryZjjlxxListByPage", paramMap, pageable);
        bdcZjjlService.exportZjjlxx(queryZjtjxxList.getRows(), request, response);
    }

    @RequestMapping("/exportZjtjxx")
    @ResponseBody
    public void exportZjtjxx(Pageable pageable, HttpServletRequest request, HttpServletResponse response,
                             @RequestParam(value = "zjksrq", required = false) String zjksrq,
                             @RequestParam(value = "zjjsrq", required = false) String zjjsrq,
                             @RequestParam(value = "zjr", required = false) String zjr,
                             @RequestParam(value = "zjbhg", required = false) String zjbhg) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("zjksrq", zjksrq);
        paramMap.put("zjjsrq", zjjsrq);
        paramMap.put("zjr", zjr);
        paramMap.put("zjbhg", zjbhg);
        Page<Map> queryZjtjxxList = repository.selectPaging("queryZjtjxxListByPage", paramMap, pageable);
        bdcZjjlService.exportZjtjxx(queryZjtjxxList.getRows(), request, response);
    }

    @RequestMapping("/zjyj")
    public String bdczjYj(Model model, @RequestParam(value = "proid", required = false) String proid, @RequestParam(value = "taskid", required = false) String taskid) {
        BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
        if (bdcXm != null) {
            model.addAttribute("wiid", bdcXm.getWiid());
        }
        List<PfSignVo> signList = signService.getSignList("zjr", proid);
        if (CollectionUtils.isNotEmpty(signList)) {
            model.addAttribute("qm", signList.get(0).getSignName());
        }
        Date zjjsrq = new Date();
        model.addAttribute("proid", proid);
        model.addAttribute("zjjsrq", zjjsrq);
        model.addAttribute("taskid", taskid);
        model.addAttribute("zjr", SessionUtil.getCurrentUser().getUsername());
        return "query/zj/bdczjYj";
    }

    @RequestMapping("/zjhg")
    @ResponseBody
    private void zjhg(BdcZjjl bdcZjjl) {
        bdcZjjlService.updateBdczjjl(bdcZjjl);
    }

    @RequestMapping("/zjbhg")
    @ResponseBody
    private Map zjbhg(BdcZjjl bdcZjjl, @RequestParam(value = "thyj", required = false) String thyj) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        String msg = StringUtils.EMPTY;
        bdcZjjlService.updateBdczjjl(bdcZjjl);
        msg = bdcZjjlService.turnBack(bdcZjjl.getWiid(), thyj);
        resultMap.put("msg", msg);
        return resultMap;
    }

    @RequestMapping("/getTaskid")
    @ResponseBody
    public Map zjjlIndex(@RequestParam(value = "wiid", required = false) String wiid) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        String taskid = PlatformUtil.getTaskidByWiid(wiid);
        resultMap.put("taskid", taskid);
        return resultMap;
    }

    @RequestMapping("/getWorkflowDefinitions")
    @ResponseBody
    public Object getWorkflowDefinitions(@RequestParam(value = "businessId", required = false) String businessId) {
        List<PfWorkFlowDefineVo> workFlowDefineVoList = null;
        if (StringUtils.isBlank(businessId)) {
            workFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();
        } else {
            workFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineByBusiness(businessId);
        }
        return workFlowDefineVoList;
    }

    @RequestMapping("/getWorkflowActivitys")
    @ResponseBody
    public Object getWorkflowActivitys(@RequestParam(value = "wfDefintionId", required = false) String wfDefintionId) {
        List<PfActivityVo> pfActivityVoList = new ArrayList<PfActivityVo>();
        if (StringUtils.isNotBlank(wfDefintionId)) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wfDefintionId);
            if (pfWorkFlowDefineVo != null) {
                WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(pfWorkFlowDefineVo);
                if (xmlDao != null) {
                    List<PfActivityVo> pfActivityVoLists = xmlDao.getPfActivityVoList();
                    if (CollectionUtils.isNotEmpty(pfActivityVoLists)) {
                        for (PfActivityVo activityVo : pfActivityVoLists) {
                            if (StringUtils.equals(Constants.WORKFLOW_ZJLCJD, activityVo.getActivityName())) {
                                pfActivityVoList.add(activityVo);
                            }
                        }
                    }

                }
            }
        }
        return pfActivityVoList;
    }

    @RequestMapping("/tszj")
    public String bdctszj(Model model, @RequestParam(value = "proid", required = false) String proid, @RequestParam(value = "zjyy", required = false) String zjyy, @RequestParam(value = "taskid", required = false) String taskid) {
        BdcXm bdcXm = bdcXmService.getBdcXmByProid(proid);
        if (bdcXm != null) {
            model.addAttribute("wiid", bdcXm.getWiid());
        }
        List<PfUserVo> pfUserVoList = bdcZjjlService.getPfuserByRoleName(AppConfig.getProperty("zjjsmc"));
        model.addAttribute("pfUserVoList", pfUserVoList);
        Date zjjsrq = new Date();
        model.addAttribute("proid", proid);
        model.addAttribute("zjjsrq", zjjsrq);
        model.addAttribute("taskid", taskid);
        model.addAttribute("zjr", SessionUtil.getCurrentUser().getUsername());
        return "query/zj/tszj";
    }
}
