package cn.gtmap.estateplat.config.web.ztxx;

import cn.gtmap.estateplat.config.core.service.RepositoryService;
import cn.gtmap.estateplat.config.service.ztxx.ZszmZtService;
import cn.gtmap.estateplat.config.web.main.BaseController;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.Map;

/*
 * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
 * @version 1.0, 2017/11/29
 * @description 不动产证书证明状态查询
 */
@Controller
@RequestMapping("/zszmZt")
public class ZszmZtController extends BaseController {

    @Autowired
    RepositoryService repositoryService;
    @Autowired
    ZszmZtService zszmZtService;

    /**
     * 证书证明状态维护页面
     *
     * @param model
     * @return "ztxx/bdcCxZszmZt”证书证明状态维护页面
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     */
    @RequestMapping(value = "/index")
    public String index(Model model) {

        return "ztxx/bdcCxZszmZt";
    }

    /**
     * 证书证明状态维护页面
     *
     * @param pageable 分页信息
     * @return 查询出来的证书证明信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     */
    @ResponseBody
    @RequestMapping("/getBdcCxZszmZtPagesJson")
    public Object getBdcCxZszmZtPagesJson(Pageable pageable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Page<HashMap> dataPaging = repositoryService.selectPaging("getBdcCxZszmZtByPage", map, pageable);
        return dataPaging;
    }

    /**
     * 初始化证书证明查询表
     *
     * @return 返回信息
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     */
    @ResponseBody
    @RequestMapping(value = "/initBdcCxZszmZt", method = RequestMethod.POST)
    public Map initBdcCxZszmZt() {
        Map map = Maps.newHashMap();
        String returnvalue = "fail";
        returnvalue=zszmZtService.initBdcCxZszmZt();
        map.put("msg", returnvalue);
        return map;
    }
}
