package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.BaseTest;
import cn.gtmap.estateplat.config.core.mapper.config.BdcCxZszmZtMapper;
import cn.gtmap.estateplat.config.core.mapper.config.GdXmMapper;
import cn.gtmap.estateplat.config.service.ztxx.BdcCxZszmZtService;
import cn.gtmap.estateplat.config.core.service.BdcZsService;
import cn.gtmap.estateplat.config.utils.RuleThread;
import cn.gtmap.estateplat.model.server.core.BdcCxZszmZt;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * @author <a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
 * @version 1.0, 2017/12/22
 * @description 
 */public class BdcCxZszmZtServiceImplTest extends BaseTest {
    @Autowired
    BdcCxZszmZtService bdcCxZszmZtService;
    @Autowired
    BdcZsService bdcZsService;
    @Autowired
    GdXmMapper gdXmMapper;
    @Autowired
    BdcCxZszmZtMapper bdcCxZszmZtMapper;
    /**
     * 线程池管理实例
     */
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;

    @Test
    public void updateZszmZtByCqzh() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap param = new HashMap();
        param.put("gxqlzt", "true");
        //计算bdccxzszmzt表中的数据量
        Integer bdcCxZszmZtCount=bdcCxZszmZtMapper.getBdcCxZszmZtNum(param);
        //超出该数据量大小则需要开始线程处理
        double limit=50000;
        if(bdcCxZszmZtCount > limit){
            System.out.println("权利更新开始时间："+df.format(System.currentTimeMillis()));
            //设置每个线程执行的数据量
            double limitcount=10000;
            double num = Math.ceil(bdcCxZszmZtCount.doubleValue() / limitcount);
            for (int k = 0; k < num; k++) {
                double begin = k * limitcount+1 ;
                double over = begin + limitcount-1;
                if (k == num - 1) {
                    over = bdcCxZszmZtCount;
                }
                param.put("begin", begin);
                param.put("over", over);
                List<BdcCxZszmZt> bdcCxZszmZts = bdcCxZszmZtMapper.listBdcCxZszmZt(param);
                while (true) {
                    try {
                        int count = taskExecutor.getActiveCount();
                        if (count < taskExecutor.getMaxPoolSize()) {
                            RuleThread ruleThread = new RuleThread();
                            ruleThread.setName("更新权利状态线程" +k);
                            ruleThread.setBdcCxZszmZts(bdcCxZszmZts);
                            ruleThread.setBdcCxZszmZtService(bdcCxZszmZtService);
                            taskExecutor.execute(ruleThread);
                            break;
                        }
                        Thread.sleep(1000 * 60);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            shutDownThread();
            System.out.println("权利更新结束时间："+df.format(System.currentTimeMillis()));
        }else{
            List<BdcCxZszmZt> bdcCxZszmZts = bdcCxZszmZtMapper.listBdcCxZszmZt(param);
            if (CollectionUtils.isNotEmpty(bdcCxZszmZts)) {
                for (BdcCxZszmZt bdcCxZszmZt : bdcCxZszmZts) {
                    if (StringUtils.isNotBlank(bdcCxZszmZt.getCqzh()) && StringUtils.isNotBlank(bdcCxZszmZt.getSjly())) {
                        bdcCxZszmZtService.updateZszmZtByCqzh(bdcCxZszmZt);
                    }
                }
            }
        }
    }

    @Test
    public void initBdcZs() throws Exception {
        //去取不动产证书的个数
        Integer bdczsNum = bdcZsService.getBdczsCount();
        //超出该数据量大小则需要开始线程处理
        double limit=50000;
        if (bdczsNum > limit) {
            //设置每个线程执行的数据量
            double limitcount=10000;
            double num = Math.ceil(bdczsNum.doubleValue() / limitcount);
            for (int k = 0; k < num; k++) {
                double begin = k * limitcount+1 ;
                double over = begin + limitcount-1;
                if (k == num - 1) {
                    over = bdczsNum;
                }
                HashMap map = new HashMap();
                map.put("begin", begin);
                map.put("over", over);
                List<BdcZs> bdcZsList = bdcZsService.listBdcZsxx(map);
                while (true) {
                    try {
                        int count = taskExecutor.getActiveCount();
                        if (count < taskExecutor.getMaxPoolSize()) {
                            RuleThread ruleThread = new RuleThread();
                            ruleThread.setName("初始化不动产证书线程" +k);
                            ruleThread.setBdcZsList(bdcZsList);
                            ruleThread.setBdcCxZszmZtService(bdcCxZszmZtService);
                            taskExecutor.execute(ruleThread);
                            break;
                        }
                        Thread.sleep(1000 * 60);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            shutDownThread();

        } else {
            List<BdcZs> bdcZsList = bdcZsService.listBdcZsxx(new HashMap());
            bdcCxZszmZtService.initBdcZs(bdcZsList);
        }
    }

    @Test
    public void initGdZs() throws Exception {
        //去取过渡证书的个数
        Integer gdzsNum = gdXmMapper.listGdZsxxsCount();
        //超出该数据量大小则需要开始线程处理
        double limit=50000;
        if(gdzsNum > limit){
            //设置每个线程执行的数据量
            double limitcount=10000;
            double num = Math.ceil(gdzsNum.doubleValue() / limitcount);
            for (int k = 0; k < num; k++) {
                double begin = k * limitcount+1 ;
                double over = begin + (limitcount-1);
                if (k == num - 1) {
                    over = gdzsNum;
                }
                HashMap map = new HashMap();
                map.put("begin", begin);
                map.put("over", over);
                List<Map> gdZsList = gdXmMapper.listGdZsxx(map);
                while (true) {
                    try {
                        int count = taskExecutor.getActiveCount();
                        if (count < taskExecutor.getMaxPoolSize()) {
                            RuleThread ruleThread = new RuleThread();
                            ruleThread.setName("初始化过渡证书线程" +k);
                            ruleThread.setGdZsList(gdZsList);
                            ruleThread.setBdcCxZszmZtService(bdcCxZszmZtService);
                            taskExecutor.execute(ruleThread);
                            break;
                        }
                        Thread.sleep(1000 * 60);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            shutDownThread();
        }else{
            List<Map> gdZsList = gdXmMapper.listGdZsxx(new HashMap());
            bdcCxZszmZtService.initGdZs(gdZsList);
        }
    }

    private void shutDownThread() {
        while (true) {
            int count = taskExecutor.getActiveCount();
            if (count == 0) {
                taskExecutor.shutdown();
                logger.info("线程池断开连接。。。");
                break;
            } else {
                logger.info("线程池尚在工作中，当前触发" + count + "个线程");
                try {
                    Thread.sleep(1000 * 60);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

}