package cn.gtmap.estateplat.config.service.impl;

import cn.gtmap.estateplat.config.BaseTest;
import cn.gtmap.estateplat.config.service.ProjectCheckInfoService;
import cn.gtmap.estateplat.model.server.core.Project;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

import static org.junit.Assert.*;

/**
 * @version 1.0, 2017/7/5.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public class ProjectCheckInfoServiceImplTest extends BaseTest {
    @Autowired
    ProjectCheckInfoService projectCheckInfoService;

    @Test
    public void testCheck() throws Exception {
        test109();
    }

    public void test103() {
        Project project = new Project();
        project.setBdcdyh("320508023054GB40827F00010009");
        Map<String, Object> map = projectCheckInfoService.testCheck("103", project);
        Assert.assertNotNull(map.get("info"));
    }

    public void test104() {
        Project project = new Project();
        project.setBdcdyh("320508023054GB40828F00010025");
        Map<String, Object> map = projectCheckInfoService.testCheck("104", project);
        Assert.assertNotNull(map.get("info"));
    }

    public void test105() {
        Project project = new Project();
        project.setBdcdyh("320508023053GB00013F00010001");
        Map<String, Object> map = projectCheckInfoService.testCheck("105", project);
        Assert.assertNotNull(map.get("info"));
    }

    public void test106() {
        Project project = new Project();
        project.setBdcdyh("345435");
        Map<String, Object> map = projectCheckInfoService.testCheck("106", project);
        Assert.assertNotNull(map.get("info"));
    }

    public void test107() {
        Project project = new Project();
        Map<String, Object> map = null;
        //房屋抵押
        project.setGdproid("FSYQ-150606133");
        map = projectCheckInfoService.testCheck("107", project);
        Assert.assertNotNull(map.get("info"));
        //bdc抵押
        project.setGdproid("FSYQ-031005277");
        map = projectCheckInfoService.testCheck("107", project);
        Assert.assertNotNull(map.get("info"));
        //土地抵押
        project.setGdproid("TSYQ-44272");
        map = projectCheckInfoService.testCheck("107", project);
        Assert.assertNotNull(map.get("info"));
    }

    public void test108() {
        //未通过
        Project project = new Project();
        project.setProid("06RD085883H6G2LY");
        project.setBdcdyh("320509400035GB00021F00190093");
        Map<String, Object> map = projectCheckInfoService.testCheck("108", project);
        Assert.assertNotNull(map.get("info"));
    }

    public void test109() {
        Project project = new Project();
        project.setBdcdyh("320509100046GB00061F00010141");
        Map<String, Object> map = projectCheckInfoService.testCheck("109", project);
        Assert.assertNotNull(map.get("info"));
    }

    public void test136() {
        Project project = new Project();
        project.setBdcdyh("320508023054GB18804F00040204");
        Map<String, Object> map = projectCheckInfoService.testCheck("136", project);
        Assert.assertNotNull(map.get("info"));
    }
}