<@com.html title="权利人信息" import="ace,public">
<style>
    /*新建弹出框的样式修改及ie8居中问题*/
    #myModal .modal-dialog {
        width: 1000px;
        margin: 30px auto;
    }

    #myModal .bootbox-body {
        height: 580px;
        padding: 0px;
    }

    .step-content .step-pane {
        min-height: 50px;
        padding: 0px 10px 0px 5px;
    }

    .profile-user-info-striped .profile-info-name {
        color: #fff;
        background-color: #408fc6;
        border-top: 1px solid #408fc6;
        width: 130px;
    }

    .profile-info-value > input {
        width: 200px;
    }
</style>
<script>
    $(function () {
        //下拉框  含搜索的
        $('.chosen-select').chosen({allow_single_deselect: true, no_results_text: "无匹配数据", width: "100%"});
        //resize the chosen on window resize
        $(window).on('resize.chosen', function () {
            $.each($('.chosen-select'), function (index, obj) {
                $(obj).next().css("width", 0);
                var w = $(obj).parent().width();
                $(obj).next().css("width", w);
            });
            $.each($('.chosen-single-select'), function (index, obj) {
                $(obj).next().css("width", 0);
                var e = $(obj).parent().width();
                $(obj).next().css("width", e);
            })
        }).trigger('resize.chosen');


        //生成表格
        BdcDyaqTableConfigGrid();
        fillBankTable();

        //新增
        $("#addData").click(function () {
            var bdcdyh = "${bdcdyh!}";
            var bdclx = "${bdclx!}";
            var djId = "${djId!}";
            var qllx = "${qllx!}";
            $.blockUI({message: "请稍等......"});
            $.ajax({
                url: "${configUrl!}/dataManager/addData",
                type: "POST",
                data: {bdcdyh: bdcdyh, bdclx: bdclx, djId: djId, qllx: qllx},
                success: function (result) {
                    setTimeout($.unblockUI, 10);
                    if (isNotBlank(result)) {
                        window.parent.showModal("${configUrl}/dataManager/dataInfo?qllx=18&proid=" + result + "&bdcdyh=${bdcdyh!}&bdclx=${bdclx!}", "抵押信息");
                        window.parent.parent.$("#dataInfoModal").on('hide.bs.modal', function () {
                            $("#limit-table-grid-table").trigger("reloadGrid");
                        });
                    }
                }
            });
        });
        //删除
        $("#delData").click(function () {
            var ids = $('#limit-table-grid-table').jqGrid('getGridParam', 'selarrrow');
            delRule(ids, "${configUrl}/bdcDyaq/delDyaq", "limit-table-grid-table");
        });

        //修改
        $("#updateData").click(function () {
            var ids = $('#limit-table-grid-table').jqGrid('getGridParam', 'selarrrow');
            if (ids.length == 0) {
                tipInfo("请选择一条数据!");
                return;
            }
            if (ids.length > 1) {
                tipInfo("只能同时修改一条数据!");
                return;
            }
            var data = $('#limit-table-grid-table').getRowData(ids);
            var proid = data.PROID;
            window.parent.showModal("${configUrl}/dataManager/dataInfo?qllx=18&proid=" + proid + "&bdcdyh=${bdcdyh!}&bdclx=${bdclx!}", "抵押信息");
            window.parent.parent.$("#dataInfoModal").on('hide.bs.modal', function () {
                $("#limit-table-grid-table").trigger("reloadGrid");
            });
        });


        $(window).on('resize.jqGrid', function () {
            var contentWidth;
            if ($("#limitTableContent").width() > 0) {
                contentWidth = $("#limitTableContent").width();
            }
            $("#limit-table-grid-table").jqGrid('setGridWidth', contentWidth);
        });

        //下拉列表事件
        function fillBankTable() {
            var bdcdyh = "${bdcdyh!}";
            $("#limit-table-grid-table").jqGrid('setGridParam', {
                datatype: 'json',
                page: 1,
                url: "${configUrl}/bdcDyaq/getDyaqPagesJson?bdcdyh=" + bdcdyh,
                postData: {}
            }).trigger("reloadGrid"); //重新载入
        }
    });


    //删除判断是否没有选择数据
    function delRule(ids, url, gridId) {
        if (ids.length == 0) {
            tipInfo("请选择一条数据!");
            return;
        }
        showConfirmDialog("删除", "是否删除？", "del", "'" + ids + "','" + url + "','" + gridId + "'", "", "");
    }

    //打开table页面
    function toLimitTable() {
        $("#limitTablePop").hide();
        $("#myModal").show();
    }

    //提示
    function tipInfo(msg) {
        bootbox.dialog({
            message: "<h3><b>" + msg + "</b></h3>",
            title: "",
            buttons: {
                main: {
                    label: "关闭",
                    className: "btn-primary"
                }
            }
        });
    }

    //auth表格初始化
    function BdcDyaqTableConfigGrid() {
        var bdcdyh = "${bdcdyh!}";
        var grid_selector = "#limit-table-grid-table";
        var pager_selector = "#limit-table-grid-pager";
        //resize on sidebar collapse/expand
        var parent_column = $(grid_selector).closest('[class*="col-"]');
        $(document).on('settings.ace.jqGrid', function (ev, event_name, collapsed) {
            if (event_name === 'sidebar_collapsed' || event_name === 'main_container_fixed') {
                $(grid_selector).jqGrid('setGridWidth', parent_column.width());
            }
        });
        jQuery(grid_selector).jqGrid({
            url: "${configUrl}/bdcDyaq/getDyaqPagesJson?bdcdyh=" + bdcdyh,
            datatype: "json",
            height: 'auto',
            jsonReader: {id: 'QLID'},
            colNames: ['QLID', '业务号', '不动产单元号', '权利人', "坐落", '抵押方式', '债务履行开始时间', '债务履行结束时间', 'PROID'],
            colModel: [
                {name: 'QLID', index: 'QLID', width: '0%', sortable: false, hidden: true},
                {name: 'YWH', index: 'YWH', width: '10%', sortable: false},
                {
                    name: 'BDCDYH',
                    index: 'BDCDYH',
                    width: '16%',
                    sortable: false,
                    formatter: function (cellvalue, options, rowObject) {
                        var value = "";
                        if (isNotBlank(cellvalue)) {
                            value = cellvalue.substr(0, 6) + " " + cellvalue.substr(6, 6) + " " + cellvalue.substr(12, 7) + " " + cellvalue.substr(19);
                        }
                        return value;
                    }
                },
                {name: 'QLR', index: 'QLR', width: '8%', sortable: false},
                {name: 'ZL', index: 'ZL', width: '8%', sortable: false},
                {name: 'DYFS', index: 'DYFS', width: '5%', sortable: false},
                {
                    name: 'ZWLXKSQX',
                    index: 'ZWLXKSQX',
                    width: '6%',
                    sortable: false,
                    formatter: function (cellvalue, options, rowObject) {
                        if (!cellvalue) {
                            return "";
                        }
                        return new Date(cellvalue).Format("yyyy-MM-dd");
                    }
                },
                {
                    name: 'ZWLXJSQX',
                    index: 'ZWLXJSQX',
                    width: '6%',
                    sortable: false,
                    formatter: function (cellvalue, options, rowObject) {
                        if (!cellvalue) {
                            return "";
                        }
                        return new Date(cellvalue).Format("yyyy-MM-dd");
                    }
                },
                {name: 'PROID', index: 'PROID', width: '0%', sortable: false, hidden: true}
            ],
            viewrecords: true,
            rowNum: 10,
            rowList: [5, 10, 15],
            pagerpos: "left",
            pager: pager_selector,
            altRows: false,
            multiboxonly: true,
            multiselect: true,
            loadComplete: function () {
                var table = this;
                setTimeout(function () {
                    updatePagerIcons(table);
                    enableTooltips(table);
                    $(grid_selector).jqGrid('setGridWidth', $("#limitTableContent").width());
                }, 0);
            },
            ondblClickRow: function (rowid) {
            },
            caption: "",
            autowidth: true
        });

    }

    //replace icons with FontAwesome icons like above
    function updatePagerIcons(table) {
        var replacement =
                {
                    'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
                    'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
                    'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
                    'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140'
                };
        $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
            var icon = $(this);
            var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

            if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
        })
    }

    function enableTooltips(table) {
        $('.navtable .ui-pg-button').tooltip({container: 'body'});
        $(table).find('.ui-pg-div').tooltip({container: 'body'});
    }

    function del(ids, url, gridId) {
        $.getJSON(url + "?qlids=" + ids, {}, function (jsonData) {
            setTimeout($.unblockUI, 10);
            tipInfo(jsonData.result);
            $('#' + gridId).trigger("reloadGrid");
        })
    }

    function openWin(url) {
        var w_width = screen.availWidth - 100;
        var w_height = screen.availHeight - 320;
        window.open(url, "", "left=1,top=0,height=" + w_height + ",width=" + w_width + ",resizable=yes,scrollbars=yes");
    }
</script>
<div class="main-container">
    <div class="space-10"></div>
    <div class="page-content" id="limitTableContent">
        <div class="tableHeader">
            <ul>
                <li>
                    <button type="button" id="addData" name="add">
                        <i class="ace-icon fa fa-download"></i>
                        <span>新增</span>
                    </button>
                </li>
                <li>
                    <button type="button" id="updateData" name="edit">
                        <i class="ace-icon fa fa-pencil"></i>
                        <span>修改</span>
                    </button>
                </li>
                <li>
                    <button type="button" id="delData" name="del">
                        <i class="ace-icon glyphicon glyphicon-remove"></i>
                        <span>删除</span>
                    </button>
                </li>
            </ul>
        </div>
        <table id="limit-table-grid-table"></table>
        <div id="limit-table-grid-pager"></div>
    </div>

<#--无用div 防止ace报错-->
    <div id="navbar" class="navbar navbar-default" hidden="hidden"></div>
    <div class="modal-backdrop fade in Pop" style="display:none" id="modal-backdrop-pop"></div>
    <input type="hidden" id="valiteType" name="valiteType">
</@com.html>