<@com.html title="权利其他状况配置" import="ace,public">
<style>
    /*新建弹出框的样式修改及ie8居中问题*/
    #myModal .modal-dialog {
        width: 1000px;
        margin: 30px auto;
    }

    #myModal .bootbox-body {
        height: 580px;
        padding: 0px;
    }

    .new-modal {
        width: 600px;
    }

    .ui-jqgrid-bdiv {
        overflow-x: hidden !important;
    }

    .modal-dialog {
        width: 650px;
        margin: 30px auto;
    }

    .col-xs-4, .col-xs-3 {
        padding-left: 6px;
        padding-bottom: 10px;
    }

    .ui-jqgrid-bdiv {
        overflow-x: hidden !important;
    }

    .widget-title {
        color: #fff;
        font-size: 24px;
    }

    .widget-main {
        padding: 10px;
    }

    .step-content .step-pane {
        min-height: 50px;
        padding: 0px 10px 0px 5px;
    }

    .profile-user-info-striped .profile-info-name {
        color: #fff;
        background-color: #408fc6;
        border-top: 1px solid #408fc6;
        width: 130px;
    }

    .wizard-actions {
        padding: 0px 20px 0px 0px;
    }
</style>
<script>
    $(function () {
        //下拉框  含搜索的
        $('.chosen-select').chosen({allow_single_deselect: true, no_results_text: "无匹配数据", width: "100%"});
        //resize the chosen on window resize
        $(window).on('resize.chosen', function () {
            $.each($('.chosen-select'), function (index, obj) {
                $(obj).next().css("width", 0);
                var w = $(obj).parent().width();
                $(obj).next().css("width", w);
            })
            $.each($('.chosen-single-select'), function (index, obj) {
                $(obj).next().css("width", 0);
                var e = $(obj).parent().width();
                $(obj).next().css("width", e);
            })
        }).trigger('resize.chosen');

        //生成表格
        BdcQllxDjsyTableConfigGrid();
        fillBankTable();


        //bank新增
        $("#addBdcData").click(function () {
            var url = "${configUrl}/bdcXtQlqtzkConfig/viewQlqtzk?type=save";
            window.parent.parent.showModel(url, "权利其他状况配置");
        });
        //bank删除
        $("#delData").click(function () {
            var sqlxs = $('#limit-table-grid-table').jqGrid('getGridParam', 'selarrrow');
            if (sqlxs.length == 0) {
                tipInfo("请选择一条数据!");
                return;
            }
            showConfirmDialog("删除提示", "确定删除选中的数据？", "delQlqtzk", "", "", "");
        });

        //bank修改
        $("#updateData").click(function () {
            var ids = $('#limit-table-grid-table').jqGrid('getGridParam', 'selarrrow');
            if (ids.length == 0) {
                tipInfo("请选择一条数据!");
                return;
            }
            if (ids.length > 1) {
                tipInfo("只能同时修改一条数据!");
                return;
            }
            var ids = $('#limit-table-grid-table').jqGrid('getGridParam', 'selarrrow');
            var data = $('#limit-table-grid-table').getRowData(ids);
            var url = "${configUrl}/bdcXtQlqtzkConfig/viewQlqtzk?type=update&sqlx=" + encodeURIComponent(data.SQLXDM) + "&qllx=" + encodeURIComponent(data.QLLXDM) + "&qllxzlx=" + encodeURIComponent(data.QLLXZLX) + "&djzx=" + encodeURIComponent(data.DJZXDM)+ "&ids=" + encodeURIComponent(data.ID);
            window.parent.parent.showModel(url, "权利其他状况配置");
        });

        $("#search").click(function () {
            var url = "${configUrl}/bdcXtQlqtzkConfig/getBdcXtQlqtzkConfigPagesJson?" + $("#searchForm").serialize();
            fillBankTable(url);
        });
        //resize to fit page size
        $(window).on('resize.jqGrid', function () {
            var contentWidth;
            if ($("#limitTableContent").width() > 0) {
                contentWidth = $("#limitTableContent").width();
            }
            $("#limit-table-grid-table").jqGrid('setGridWidth', contentWidth);
        });

        //下拉列表事件

        //申请类型变换
        $("#sqlx").change(function () {
            var sqlx = $("#sqlx  option:selected").text();
            getDjzxBySqlx(sqlx);
        })
    });

    function fillBankTable(url) {
        if (url == null || url == '')
            url = "${configUrl}/bdcXtQlqtzkConfig/getBdcXtQlqtzkConfigPagesJson";
        $("#limit-table-grid-table").jqGrid('setGridParam', {
            datatype: 'json',
            page: 1,
            url: url,
            postData: {}
        }).trigger("reloadGrid"); //重新载入
    }

    //提示
    function tipInfo(msg) {
        bootbox.dialog({
            message: "<h3><b>" + msg + "</b></h3>",
            title: "",
            buttons: {
                main: {
                    label: "关闭",
                    className: "btn-primary",
                }
            }
        });
    }

    //auth表格初始化
    function BdcQllxDjsyTableConfigGrid() {
        var grid_selector = "#limit-table-grid-table";
        var pager_selector = "#limit-table-grid-pager";
        //resize on sidebar collapse/expand
        var parent_column = $(grid_selector).closest('[class*="col-"]');
        $(document).on('settings.ace.jqGrid', function (ev, event_name, collapsed) {
            if (event_name === 'sidebar_collapsed' || event_name === 'main_container_fixed') {
                $(grid_selector).jqGrid('setGridWidth', parent_column.width());
            }
        });
        jQuery(grid_selector).jqGrid({
            datatype: "local",
            height: 'auto',
            jsonReader: {id: 'ID'},
            colNames: ['申请类型', '权利类型', '不动产单元房屋类型','登记子项', '权利其他状况模版', '附记模版', '申请类型代码', '权利类型代码', '房屋类代码', '登记子项代码','ID'],
            colModel: [
                {name: 'SQLXMC', index: 'SQLXMC', width: '20%', sortable: false},
                {name: 'QLLXMC', index: 'QLLXMC', width: '15%', sortable: false},
                {name: 'FWLXMC', index: 'FWLXMC', width: '15%', sortable: false},
                {name: 'DJZXMC', index: 'DJZXMC', width: '15%', sortable: false},
                {name: 'QLQTZKMB', index: 'QLQTZKMB', width: '25%', sortable: false},
                {name: 'FJMB', index: 'FJMB', width: '25%', sortable: false},
                {name: 'SQLXDM', index: 'SQLXDM', width: '0%', sortable: false, hidden: true},
                {name: 'QLLXDM', index: 'QLLXDM', width: '0%', sortable: false, hidden: true},
                {name: 'QLLXZLX', index: 'QLLXZLX', width: '0%', sortable: false, hidden: true},
                {name: 'DJZXDM', index: 'DJZXDM', width: '0%', sortable: false, hidden: true},
                {name: 'ID', index: 'ID', width: '0%', sortable: false, hidden: true}
            ],
            viewrecords: true,
            rowNum: 5,
            rowList: [5, 10, 15],
            pagerpos: "left",
            pager: pager_selector,
            altRows: false,
            multiboxonly: true,
            multiselect: true,
            loadComplete: function () {
                var table = this;
                setTimeout(function () {
                    updatePagerIcons(table);
                    enableTooltips(table);
                    $(grid_selector).jqGrid('setGridWidth', $("#limitTableContent").width());
                }, 0);
            },
            ondblClickRow: function (rowid) {
            },
            caption: "",
            autowidth: true
        });

    }

    //replace icons with FontAwesome icons like above
    function updatePagerIcons(table) {
        var replacement =
                {
                    'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
                    'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
                    'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
                    'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140'
                };
        $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
            var icon = $(this);
            var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

            if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
        })
    }

    function enableTooltips(table) {
        $('.navtable .ui-pg-button').tooltip({container: 'body'});
        $(table).find('.ui-pg-div').tooltip({container: 'body'});
    }


    function openWin(url) {
        var w_width = screen.availWidth - 10;
        var w_height = screen.availHeight - 32;
        window.open(url, "", "left=1,top=0,height=" + w_height + ",width=" + w_width + ",resizable=yes,scrollbars=yes");
    }

    function delQlqtzk() {
        $.blockUI({message: "请稍等……"});
        var sqlxs = $('#limit-table-grid-table').jqGrid('getGridParam', 'selarrrow');
        var data = "";
        if (sqlxs && sqlxs != 'undefined') {
            if (sqlxs.length > 0)
                data = sqlxs.join("/");
            else
                data = sqlxs;
            $.ajax({
                url: "${configUrl}/bdcXtQlqtzkConfig/deleteQlqtzk?data=" + data,
                type: "post",
                success: function (data) {
                    setTimeout($.unblockUI, 10);
                    alert(data);
                    $('#limit-table-grid-table').trigger("reloadGrid");
                },
                error: function (data) {
                    setTimeout($.unblockUI, 10);
                    alert(data);
                }
            });
        }
    }
    
    function getDjzxBySqlx(sqlx) {

        $.ajax({
            type: "GET",
            url: "${configUrl}/bdcXtQlqtzkConfig/getDjzxBySqlx" ,
            data:{sqlx:sqlx},
            dataType: "json",
            success: function (result) {
                //清空
                $("#djzx").html("");
                if (result != null && result != '') {
                    $("#djzx").append('<option value="" >全部</option>');
                    $.each(result, function (index, data) {
                        $("#djzx").append('<option value="' + data.dm + '" >' + data.mc + '</option>');
                    })
                }
                $("#djzx").trigger("chosen:updated");

            },
            error: function (data) {
            }
        });
        
    }
</script>
<div class="main-container">
    <div class="space-10"></div>
    <div class="page-content" id="limitTableContent">
        <form id="searchForm">
            <div class="row">
                <div class="col-xs-4">
                    <div class="profile-user-info profile-user-info-striped">
                        <div class="profile-info-name"> 申请类型</div>
                        <div class="profile-info-value">
                            <select name="sqlx" id="sqlx" class="chosen-select" data-placeholder=" ">
                                <option value="">全部</option>
                                <#list sqlxList as sqlx>
                                    <option value="${sqlx.dm!}">${sqlx.mc!}</option>
                                </#list>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-xs-3">
                    <div class="profile-user-info profile-user-info-striped">
                        <div class="profile-info-name"> 权利类型</div>
                        <div class="profile-info-value">
                            <select name="qllx" id="qllx" class="chosen-select" data-placeholder=" ">
                                <option value="">全部</option>
                                <#list qllxList as qllx>
                                    <option value="${qllx.dm!}">${qllx.mc!}</option>
                                </#list>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-xs-4">
                    <div class="profile-user-info profile-user-info-striped">
                        <div class="profile-info-name" style="width: 150px">不动产单元房屋类型</div>
                        <div class="profile-info-value">
                            <select name="fwlx" id="fwlx" class="chosen-select" data-placeholder=" ">
                                <option value="">全部</option>
                                <#list fwlxList as fwlx>
                                    <option value="${fwlx.DM!}">${fwlx.MC!}</option>
                                </#list>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-4">
                    <div class="profile-user-info profile-user-info-striped">
                        <div class="profile-info-name"> 登记子项</div>
                        <div class="profile-info-value">
                            <select name="djzx" id="djzx" class="chosen-select" data-placeholder=" ">
                                <option value="">全部</option>
                                <#list djzxList as djzx>
                                    <option value="${djzx.dm!}">${djzx.mc!}</option>
                                </#list>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-xs-1">
                    <button type="button" class="btn btn-sm btn-primary" id="search" name="search">查询</button>
                </div>
            </div>
    </form>
    <div class="tableHeader">
        <ul>
            <li>
                <button type="button" id="addBdcData" name="add">
                    <i class="ace-icon fa fa-download"></i>
                    <span>新建</span>
                </button>
            </li>
            <li>
                <button type="button" id="updateData" name="edit">
                    <i class="ace-icon fa fa-pencil"></i>
                    <span>修改</span>
                </button>
            </li>
            <li>
                <button type="button" id="delData" name="del">
                    <i class="ace-icon glyphicon glyphicon-remove"></i>
                    <span>删除</span>
                </button>
            </li>
        </ul>
    </div>
    <table id="limit-table-grid-table"></table>
    <div id="limit-table-grid-pager"></div>
</div>
<#--新建验证-->


<#--无用div 防止ace报错-->
    <div id="navbar" class="navbar navbar-default" hidden="hidden"></div>
    <div class="modal-backdrop fade in Pop" style="display:none" id="modal-backdrop-pop"></div>
    <input type="hidden" id="valiteType" name="valiteType">
</@com.html>