<@com.html title="不动产单元状态管理" import="ace,public">
<style type="text/css">
    .bdcdyTitle {
        color: #fff;
        padding-top: 10px;
    }
</style>
<script type="text/javascript">
    $(function () {
        //绑定回车键
        $(document).keydown(function(event){
            if(event.keyCode==13){
                $("#search").trigger("click");
            }
        });
        //查询不动产单元
        $("#search").click(function () {
            var bdcdyh = $("#bdcdyh").val();
            $("#bdcdy-grid-table").jqGrid('setGridParam', {
                datatype: 'json',
                page: 1,
                url: "${configUrl}/bdcdyZt/getBdcZtPagesJson?bdcdyh=" + encodeURI(bdcdyh)
            }).trigger("reloadGrid"); //重新载入
        });
    });
    //历史不动产单元数据转换
    function lsDate() {
        $.blockUI({message: "正在处理，请稍等……"});
        $.ajax({
            url:  "${configUrl}/bdcdyZt/lsDate",
            type: 'POST',
            dataType: 'json',
            data: '',
            success: function (data) {
                setTimeout($.unblockUI, 10);
                if (isNotBlank(data)) {
                    if (data.result == "success") {
                        alert("转换结束!");
                        $("#bdcdy-grid-table").trigger("reloadGrid");//刷新失败数据
                    }
                }
            },
            error: function (data) {
                alert("转换失败!");
            }
        });
    }
    //验证不动产单元状态表是否有数据
    function  valiteBdcdy() {
        $.ajax({
            url:  "${configUrl}/bdcdyZt/valiteBdcdy",
            type: 'POST',
            dataType: 'json',
            data: '',
            success: function (data) {
                if (isNotBlank(data)) {
                    if (data.result == "true") {
                        showConfirmDialog("提示", "已转过不动产状态数据，是否重新转换？", "lsDate", "","", "");
                    }else{
                        lsDate();
                    }
                }
            },
        });
    }
</script>
<div class="main-container">
    <@p.queryForm>
        <@p.queryRow>
            <@p.queryItem label="不动产单元号" name="bdcdyh" itemType="text" ></@p.queryItem>
            <@p.queryBars>
                <@p.queryBar text="查询" id="search"/>
            </@p.queryBars>
            <@p.queryBars>
                <@p.queryBar text="历史数据转换" handler="valiteBdcdy()"/>
            </@p.queryBars>
        </@p.queryRow>
    </@p.queryForm>
    <div class="page-content" id="mainContent">
    <#--列表按钮-->
        <@p.toolBars>
            <h5 class="bdcdyTitle">&nbsp;&nbsp;不动产单元转换列表</h5>
        </@p.toolBars>
        <@p.list tableId="bdcdy-grid-table" pageId="bdcdy-grid-pager" keyField="ZTID" dataUrl="${configUrl}/bdcdyZt/getBdcZtPagesJson" multiboxonly="false"multiselect="false">
            <@p.field fieldName="ZTID" header="ZTID" width="0%"  hidden="true"/>
            <@p.field fieldName="XH" header="序列" width="2%"/>
            <@p.field fieldName="BDCDYH" header="不动产单元号" width="5%"/>
            <@p.field fieldName="QLR"  header="权利人" width="5%" />
            <@p.field fieldName="ZL" header="坐落" width="5%"/>
            <@p.field fieldName="DJZT" header="登记状态" width="5%"/>
            <@p.field fieldName="SCDJZT" header="首次登记状态" width="5%"/>
            <@p.field fieldName="BDCQZH" header="不动产权证号" width="5%"/>
        </@p.list>
        <table id="bdcdy-grid-table"></table>
        <div id="bdcdy-grid-pager"></div>
    </div>
</div>
<#--无用div 防止ace报错-->
<div id="navbar" class="navbar navbar-default" hidden="hidden"></div>
</@com.html>