<@com.html title="移民搬迁户" import="ace,public">
<style>
    body, html {
        margin: 0;
        padding: 0;
        background-color: white;
    }

    label {
        font-weight: bold;
    }

    .main-container {
        margin-left: 20px;
        margin-right: 20px;
    }

    .firstTitle > h1 {
        text-align: center;
        font-weight: bold;
    }

    .page-content {
        margin: 0;
        padding: 0;
    }

    .modal-dialog {
        width: 1000px;
    }

    /*a  upload */
    .a-upload {
        padding: 4px 10px;
        height: 30px;
        line-height: 20px;
        position: relative;
        cursor: pointer;
        color: #888;
        background: #fafafa;
        border: 1px solid #ddd;
        border-radius: 4px;
        overflow: hidden;
        display: inline-block;
        *display: inline;
        *zoom: 1
    }

    .a-upload input {
        position: absolute;
        font-size: 100px;
        right: 0;
        top: 0;
        opacity: 0;
        filter: alpha(opacity=0);
        cursor: pointer
    }

    .a-upload:hover {
        color: #444;
        background: #eee;
        border-color: #ccc;
        text-decoration: none
    }

    /*高级搜索样式添加 begin*/
    /*移动modal样式*/
    #gjSearchPop .modal-dialog {
        width: 650px;
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 1050;
        -webkit-overflow-scrolling: touch;
        outline: 0;
    }

    .btn01:hover {
        background-color: #c7c7c7;
        text-decoration: none;
        color: #333;
    }

    .btn01 {
        display: inline-block;
        padding: 4px 12px;
        margin-bottom: 0;
        font-size: 14px;
        color: #333333;
        text-align: center;
        vertical-align: middle;
        cursor: pointer;
        background-color: #f2f2f2;
        border: 1px solid #aaa;
        webkit-border-radius: 0px !important;
        -moz-border-radius: 0px !important;
        border-radius: 0px !important;
    }

    .modelFooter {
        background: none;
        border-top: 1px solid #e5e5e5;
        padding: 10px;
        text-align: center;
    }

    form input[type='text'], select, textarea {
        border-radius: 4px !important;
        width;
        100% !important;
        margin: 0px 5px 0px 0px;
    }

    .form .row {
        margin: 10px 0px 10px 0px;
    }

    .form .row .col-xs-2 {
        padding-left: 0px;
        padding-right: 4px;
        text-align: right;
    }

    .form .row .col-xs-4 {
        padding-left: 0px;
        padding-right: 0px;
    }

    /*重写下拉列表高度*/
    .chosen-container > .chosen-single, [class*="chosen-container"] > .chosen-single {
        height: 34px;
    }

</style>

<script type="text/javascript">
    //全局数组
    $mulQlrid = new Array();
    //处理数组的方法
    Array.prototype.remove = function (index) {
        if (index > -1) {
            this.splice(index, 1);
        }
    };
    if (!Array.prototype.forEach) {
        Array.prototype.forEach = function(callback, thisArg) {
            var T, k;
            if (this == null) {
                throw new TypeError(" this is null or not defined");
            }
            var O = Object(this);
            var len = O.length >>> 0; // Hack to convert O.length to a UInt32
            if ({}.toString.call(callback) != "[object Function]") {
                throw new TypeError(callback + " is not a function");
            }
            if (thisArg) {
                T = thisArg;
            }
            k = 0;
            while (k < len) {
                var kValue;
                if (k in O) {
                    kValue = O[k];
                    callback.call(T, kValue, k, O);
                }
                k++;
            }
        };
    }

    $(function () {
        /*判断浏览器是否是ie8  解决ie8弹出框居中问题*/
        var ua = navigator.userAgent.toLowerCase();
        if (window.ActiveXObject) {
            if (ua.match(/msie ([\d.]+)/)[1] == '8.0') {
                $(window).resize(function () {
                    $.each($(".moveModel > .modal-dialog"), function () {
                        $(this).css("left", ($(window).width() - $(this).width()) / 2);
                        $(this).css("top", "40px");
                    })
                })
            }
        }
        //初始化jqgrid表格
        bqhTableInit();
        /*   文字水印  */
        $(".watermarkText").watermark();

        //上传Excel按钮
        $("#upBtn").click(function () {
            if (validateIe()) {
                $("#dataModal").show();
            } else {
                alert("请不要使用IE进行上传！")
            }
        });
        //上传按钮
        $("#uploadBqh").click(function () {
            var filePath = $("#getBqhFile").val();
            if (filePath.length == 0) {
                alert("请选择文件！");
            } else if (filePath.lastIndexOf("xls") == (filePath.length-3) || filePath.lastIndexOf("xlsx") == (filePath.length-4)) {
                $("#dataForm").ajaxForm({
                    url: "${configUrl}/bdcQlrbqh/readExcel",
                    type: "post",
                    clearForm: true,
                    resetForm: true,
                    success: function (res) {
                        var reg = new RegExp("\r\n", "g");
                        var data = JSON.parse(res.replace(reg, "\\r\\n"));
                        setTimeout($.unblockUI, 10);
                        if (data.statue == "success") {
                            $("#dataModal").hide();
                            $("#dataForm")[0].reset();
                            alert(data.result + data.msg);
                        } else if (data.statue == "fail") {
                            tipInfo("上传失败！");
                        }
                    },
                    error: function (result) {
                        tipInfo("上传失败！");
                    }
                });
            } else {
                alert("请检查所选文件类型！");
            }
        });
        //上传Excel关闭按钮（非ie）
        $("#uploadHide").click(function () {
            $("#dataModal").hide();
            $("#uploadBqhForm")[0].reset();
        });

        //新增按钮点击事件
        $("#addBtn").click(function () {
            $("#addBqh").show();
        });
        //新增页面  关闭
        $("#addBqhHide").click(function () {
            $("#addBqh").hide();
            $("#addBqhForm")[0].reset();
        });
        //新增页面  保存按钮
        $("#addBqhSave").click(function () {
            $("#addBqh").hide();
            $.ajax({
                type:"post",
                async:"false",
                data:$("#addBqhForm").serialize(),
                url: "${configUrl}/bdcQlrbqh/addQlrbqh",
                success:function () {
                    alert("保存成功！");
                    $("#addBqhForm")[0].reset();
                    $("#queBtn").click();
                },
                error:function () {
                    alert("保存失败，因存在异常！");
                }
            })
        });

        //删除按钮
        $("#delBtn").click(function () {
            var qlrids = $mulQlrid.join(",");
            $.ajax({
                type:"post",
                async:"false",
                data:{qlrids:qlrids},
                url:"${configUrl}/bdcQlrbqh/delQlrbqh",
                success:function () {
                    alert("删除成功！");
                    $("#queBtn").click();
                },
                error:function () {
                    alert("删除失败，因存在异常！");
                }
            })
        });

        //修改按钮
        $("#modBtn").click(function () {
            var count = $mulQlrid.length;
            if (count == 0) {
                alert("请选择至少一条数据进行修改！")
            } else if (count > 1) {
                alert("选择了多条数据，请重新选择！")
            } else {
                var qlrid = $mulQlrid[0];
                var dataBqh = $("#bqh-grid-table").jqGrid('getRowData', qlrid);
                $("#addBqh_qlrid").val(qlrid.QLRID);
                $("#addBqh_cm").val(dataBqh.CM);
                $("#addBqh_zm").val(dataBqh.ZM);
                $("#addBqh_qlrmc").val(dataBqh.QLRMC);
                $("#addBqh_yhzgx").val(dataBqh.YHZGX);
                $("#addBqh_sfzjh").val(dataBqh.SFZJH);
                $("#addBqh_bqnd").val(dataBqh.BQND);
                $("#addBqh_bqlx").val(dataBqh.BQLX);
                $("#addBqh_azfs").val(dataBqh.AZFS);
                $("#addBqh_qrd").val(dataBqh.QRD);
                $("#addBqh_zlgjz").val(dataBqh.ZLGJZ);
                $("#addBqh_zlgjz2").val(dataBqh.ZLGJZ2);
                $("#addBqh_zlgjz3").val(dataBqh.ZLGJZ3);
                $("#addBqh_bz").val(dataBqh.BZ);
                $("#addBqh_sfsc").val(dataBqh.SFSC);
                $("#addBqh").show();
            }
        });

        //查询按钮
        $("#queBtn").click(function () {
            var qlrmc = $("#search_qlrmc").val();
            var sfzjh = $("#search_sfzjh").val();
            var qrd = $("#search_qrd").val();
            var Url = "${configUrl}/bdcQlrbqh/queryBdcQlrbqh";
            tableReload("bqh-grid-table", Url, {qlrmc: qlrmc, sfzjh: sfzjh, qrd: qrd});
        });

        //添加关键字
        $("#addKeyBtn").click(function () {
            var count = $mulQlrid.length;
            if (count == 0) {
                alert("请选择至少一条数据进行修改！")
            }else {
                $("#addKey").show();
            }
        });
        //添加关键字保存按钮事件
        $("#addKeySave").click(function () {
            var qlrids = $mulQlrid.join(",");
            var zlgjz = $("#addKey_zlgjz").val();
            var zlgjz2 = $("#addKey_zlgjz2").val();
            var zlgjz3 = $("#addKey_zlgjz3").val();
            $.ajax({
                type:"post",
                async:"false",
                data:{qlrids:qlrids, zlgjz:zlgjz, zlgjz2:zlgjz2, zlgjz3:zlgjz3},
                url:"${configUrl}/bdcQlrbqh/addKey",
                success:function () {
                    alert("保存成功！");
                    $("#addKey").hide();
                    $("#queBtn").click();
                    $("#addKey_zlgjz").val("");
                    $("#addKey_zlgjz2").val("");
                    $("#addKey_zlgjz3").val("");
                },
                error:function () {
                    alert("保存失败！因存在异常！");
                }
            })
        });
        //添加关键字页面关闭
        $("#addKeyHide").click(function () {
            $("#addKey").hide();
            $("#addKey_zlgjz").val("");
            $("#addKey_zlgjz2").val("");
            $("#addKey_zlgjz3").val("");
        });

    });

    //jqGrid初始化
    function bqhTableInit() {
        var grid_selector = "#bqh-grid-table";
        var pager_selector = "#bqh-grid-pager";

        //resize to fit page size
        $(window).on('resize.jqGrid', function () {
            $(grid_selector).jqGrid('setGridWidth', $(".page-content").width());
        });
        //resize on sidebar collapse/expand
        var parent_column = $(grid_selector).closest('[class*="col-"]');
        $(document).on('settings.ace.jqGrid', function (ev, event_name, collapsed) {
            if (event_name === 'sidebar_collapsed' || event_name === 'main_container_fixed') {
                $(grid_selector).jqGrid('setGridWidth', parent_column.width());
            }
        });

        jQuery(grid_selector).jqGrid({
            url: "${configUrl}/bdcQlrbqh/queryBdcQlrbqh",
            datatype: "json",
            height: 'auto',
            jsonReader: {id: 'QLRID'},
            colNames: ['镇', '村', '姓名', '与户主关系', '身份证号码', '搬迁年度', '搬迁类型', '安置方式', '迁入地坐落', '关键字', '关键字2', '关键字3', '是否是"双超"整改户', 'QLRID'],
            colModel: [
                {name: 'ZM', index: 'ZM', width: '5%', sortable: false},
                {name: 'CM', index: 'CM', width: '5%', sortable: false},
                {name: 'QLRMC', index: 'QLRMC', width: '5%', sortable: false},
                {name: 'YHZGX', index: 'YHZGX', width: '5%', sortable: false},
                {name: 'SFZJH', index: 'SFZJH', width: '15%', sortable: false},
                {name: 'BQND', index: 'BQND', width: '5%', sortable: false},
                {name: 'BQLX', index: 'BQLX', width: '5%', sortable: false},
                {name: 'AZFS', index: 'AZFS', width: '5%', sortable: false},
                {name: 'QRD', index: 'QRD', width: '15%', sortable: false},
                {name: 'ZLGJZ', index: 'ZLGJZ', width: '5%', sortable: false},
                {name: 'ZLGJZ2', index: 'ZLGJZ2', width: '5%', sortable: false},
                {name: 'ZLGJZ3', index: 'ZLGJZ3', width: '5%', sortable: false},
                {name: 'SFSC', index: 'SFSC', width: '8%', sortable: false},
                {name: 'QLRID', index: 'QLRID', width: '0%', sortable: false, hidden: true}
            ],
            viewrecords: true,
            rowNum: 10,
            rowList: [10, 20, 30],
            pager: pager_selector,
            pagerpos: "left",
            altRows: false,
            multiboxonly: false,
            multiselect: true,
            loadComplete: function () {
                var table = this;
                setTimeout(function () {
                    updatePagerIcons(table);
                    enableTooltips(table);
                    var replacement =
                            {
                                'ui-icon ui-icon-plus': 'ace-icon fa fa-plus bigger-140'
                            };
                    $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
                        var icon = $(this);
                        var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

                        if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
                    })
                }, 0);
            },
            onSelectRow: function (rowid, status) {
                var rowDataBqh = $(grid_selector).jqGrid('getRowData', rowid);
                if (rowDataBqh.QLRID != 'undefined' && rowDataBqh.QLRID != '') {
                    var index = $.inArray(rowDataBqh.QLRID, $mulQlrid);
                    if (status && index < 0) {
                        $mulQlrid.push(rowDataBqh.QLRID);
                    } else if (!status && index >= 0) {
                        $mulQlrid.remove(index);
                    }
                }
            },
            onSelectAll: function (rowids, status) {
                rowids.forEach(function (e) {
                    var mulDataBqh = $(grid_selector).jqGrid('getRowData', e);
                    if (mulDataBqh.QLRID != 'undefined' && mulDataBqh.QLRID != '') {
                        var index = $.inArray(mulDataBqh.QLRID, $mulQlrid);
                        if (status && index < 0) {
                            $mulQlrid.push(mulDataBqh.QLRID);
                        }else if (!status && index >= 0) {
                            $mulQlrid.remove(index);
                        }
                    }
                })
            },
            editurl: "",
            caption: "",
            autowidth: true
        });
    }

    function enableTooltips(table) {
        $('.navtable .ui-pg-button').tooltip({container: 'body'});
        $(table).find('.ui-pg-div').tooltip({container: 'body'});
    }

    function updatePagerIcons(table) {
        var replacement =
                {
                    'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
                    'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
                    'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
                    'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140'
                };
        $('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
            var icon = $(this);
            var $class = $.trim(icon.attr('class').replace('ui-icon', ''));

            if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
        })
    }

    function tableReload(table, Url, data) {
        var jqgrid = $("#" + table);
        jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
        jqgrid.trigger("reloadGrid");//重新加载JqGrid
    }

    function validateIe() {
        if (navigator.userAgent.indexOf("MSIE") > 0) {
            if (navigator.userAgent.indexOf("MSIE 6.0") > 0) {
                return true;
            }
            if (navigator.userAgent.indexOf("MSIE 7.0") > 0) {
                return true;
            }
            if (navigator.userAgent.indexOf("MSIE 8.0") > 0) {
                return true;
            }
            if (navigator.userAgent.indexOf("MSIE 9.0") > 0) {
                return true;
            }
        } else {
            return true;
        }
    }


</script>
<div class="main-container">
    <div class="space-10"></div>
    <div class="page-content">
        <div class="space-4"></div>
        <#--主页面-->
        <div id="viewYmbqh">
            <div class="row">
                <div class="col-xs-1">
                    <label>权利人：</label>
                </div>
                <div class="col-xs-2">
                    <input type="text" id="search_qlrmc" class="form-control"/>
                </div>
                <div class="col-xs-1">
                    <label>证件号：</label>
                </div>
                <div class="col-xs-2">
                    <input type="text" id="search_sfzjh" class="form-control"/>
                </div>
                <div class="col-xs-1">
                    <label>坐落：</label>
                </div>
                <div class="col-xs-2">
                    <input type="text" id="search_qrd" class="form-control"/>
                </div>
            </div>
            <br/>
            <div class="row">
                <div class="col-xs-6">
                    <button type="button" class="btn btn-sm btn-primary" id="upBtn">上传EXCEL</button>
                    &nbsp;&nbsp;&nbsp;
                    <button type="button" class="btn btn-sm btn-primary" id="addBtn">新增</button>
                    &nbsp;&nbsp;&nbsp;
                    <button type="button" class="btn btn-sm btn-primary" id="delBtn">删除</button>
                    &nbsp;&nbsp;&nbsp;
                    <button type="button" class="btn btn-sm btn-primary" id="modBtn">修改</button>
                    &nbsp;&nbsp;&nbsp;
                    <button type="button" class="btn btn-sm btn-primary" id="queBtn">查询</button>
                    &nbsp;&nbsp;&nbsp;
                    <button type="button" class="btn btn-sm btn-primary" id="addKeyBtn">添加关键字</button>
                </div>
            </div>
            <br/>
            <div class="tableHeader"></div>
            <table id="bqh-grid-table"></table>
            <div id="bqh-grid-pager"></div>
        </div>
    </div>
</div>
<#--新增-->
<div id="addBqh" class="Pop-upBox moveModel" style="display: none;">
    <div class="modal-dialog logSearchPop-modal" style="width: 35%">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><i class="ace-icon fa fa-search bigger-110"></i>新增/修改</h4>
                <button type="button" id="addBqhHide" class="proHide"><i class="ace-icon glyphicon glyphicon-remove"></i></button>
            </div>
            <div class="bootbox-body" style="background: #fafafa;">
                <form id="addBqhForm">
                    <div class="row">
                        <div class="col-xs-2">
                            <label>镇：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_zm" name="zm"/>
                        </div>
                        <div class="col-xs-2">
                            <label>村：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_cm" name="cm"/>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-2">
                            <label>姓名：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_qlrmc" name="qlrmc"/>
                        </div>
                        <div class="col-xs-2">
                            <label>与户主关系：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_yhzgx" name="yhzgx"/>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-2">
                            <label>身份证号码：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_sfzjh" name="sfzjh"/>
                        </div>
                        <div class="col-xs-2">
                            <label>搬迁年度：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_bqnd" name="bqnd"/>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-2">
                            <label>搬迁类型：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_bqlx" name="bqlx"/>
                        </div>
                        <div class="col-xs-2">
                            <label>安置方式：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_azfs" name="azfs"/>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-2">
                            <label>迁入地坐落：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_qrd" name="qrd"/>
                        </div>
                        <div class="col-xs-2">
                            <label>关键字1：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_zlgjz" name="zlgjz"/>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-2">
                            <label>关键字2：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_zlgjz2" name="zlgjz2"/>
                        </div>
                        <div class="col-xs-2">
                            <label>关键字3：</label>
                        </div>
                        <div class="col-xs-4">
                            <input type="text" id="addBqh_zlgjz3" name="zlgjz3"/>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-3">
                            <label>是否为"双超"整改户：</label>
                        </div>
                        <div class="col-xs-3">
                            <select type="text" id="addBqh_sfsc" name="sfsc">
                                <option value="">请选择</option>
                                <option value="是">是</option>
                                <option value="否">否</option>
                            </select>
                        </div>
                    </div>
                    <input type="hidden" id="addBqh_qlrid" name="qlrid"/>
                </form>
            </div>
            <div class="modelFooter">
                <button type="button" class="btn btn-sm btn-primary" id="addBqhSave">保存</button>
            </div>
        </div>
    </div>
</div>

<#--添加关键字-->
<div id="addKey" class="Pop-upBox moveModel" style="display: none;">
    <div class="modal-dialog logSearchPop-modal" style="width: 20%">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><i class="ace-icon fa fa-search bigger-110"></i>添加关键字</h4>
                <button type="button" id="addKeyHide" class="proHide"><i class="ace-icon glyphicon glyphicon-remove"></i></button>
            </div>
            <div class="bootbox-body" style="background: #fafafa;">
                <div class="row">
                    <div class="col-xs-3">
                        <label>关键字：</label>
                    </div>
                    <div class="col-xs-4">
                        <input type="text" id="addKey_zlgjz" name="zlgjz"/>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xs-3">
                        <label>关键字2：</label>
                    </div>
                    <div class="col-xs-4">
                        <input type="text" id="addKey_zlgjz2" name="zlgjz2"/>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xs-3">
                        <label>关键字3：</label>
                    </div>
                    <div class="col-xs-4">
                        <input type="text" id="addKey_zlgjz3" name="zlgjz3"/>
                    </div>
                </div>
            </div>
            <div class="modelFooter">
                <button type="button" class="btn btn-sm btn-primary" id="addKeySave">保存</button>
            </div>
        </div>
    </div>
</div>

<#--上传Excel-->
<div id="dataModal" class="Pop-upBox moveModel" style="display: none;">
    <div class="modal-dialog logSearchPop-modal" id="dataModalDialog" style="width: 30%">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><i class="ace-icon fa fa-search bigger-110"></i>选择Excel文件</h4>
                <button type="button" id="uploadHide" class="proHide"><i class="ace-icon glyphicon glyphicon-remove"></i></button>
            </div>
            <div class="modal-body" style="background: #fafafa;">
                <form method="post" enctype="multipart/form-data" id="dataForm">
                    <div class="row" style="padding-top: 10px;">
                        <div class="col-xs-3">
                            <label>选择Excel文件:</label>
                        </div>
                        <div id="fileDiv" class="col-xs-6">
                            <input type="file" name="multipartFile" id="getBqhFile" style="height: 25px;width: 350px"/>
                        </div>
                        <div class="col-xs-1">
                            <input type="submit" id="uploadBqh" value="上      传" style="height: 25px;padding-left: 5px;padding-right: 5px;margin-left: 50px"/>
                        </div>
                    </div>
                    <div class="row" style="padding-top: 10px">
                        <div class="col-xs-4">
                            <label>下载移民搬迁户Excel模版:</label>
                        </div>
                        <div class="col-xs-3">
                            <a href="${configUrl}/static/data/ExcelTemplate/QlrbqhExcel.xls" class="form-control" style="border:none;background: #fafafa;margin-bottom: 5px;">点击此处</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<#--无用div 防止ace报错-->
<div id="navbar" class="navbar navbar-default" hidden="hidden"></div>
</@com.html>
